/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Crucible
extends SimpleSlimefunItem<BlockUseHandler>
implements RecipeDisplayItem {
    private final List<ItemStack> recipes = this.getMachineRecipes();

    public Crucible(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes;
    }

    private List<ItemStack> getMachineRecipes() {
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        items.add(new ItemStack(Material.COBBLESTONE, 16));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.NETHERRACK, 16));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.STONE, 12));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.OBSIDIAN, 1));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        items.add(new ItemStack(Material.TERRACOTTA, 12));
        items.add(new ItemStack(Material.LAVA_BUCKET));
        for (Material leave : Tag.LEAVES.getValues()) {
            items.add(new ItemStack(leave, 16));
            items.add(new ItemStack(Material.WATER_BUCKET));
        }
        for (Material sapling : SlimefunTag.TERRACOTTA.getValues()) {
            items.add(new ItemStack(sapling, 12));
            items.add(new ItemStack(Material.LAVA_BUCKET));
        }
        return items;
    }

    @Override
    public BlockUseHandler getItemHandler() {
        return e -> {
            Optional<Block> optional = e.getClickedBlock();
            if (optional.isPresent()) {
                e.cancel();
                Player p = e.getPlayer();
                Block b = optional.get();
                if (p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES)) {
                    ItemStack input = e.getItem();
                    Block block = b.getRelative(BlockFace.UP);
                    if (this.craft(p, input)) {
                        boolean water = Tag.LEAVES.isTagged((Keyed)input.getType());
                        this.generateLiquid(block, water);
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.wrong-item", true);
                    }
                }
            }
        };
    }

    @ParametersAreNonnullByDefault
    private boolean craft(Player p, ItemStack input) {
        for (int i = 0; i < this.recipes.size(); i += 2) {
            ItemStack convert = this.recipes.get(i);
            if (!SlimefunUtils.isItemSimilar(input, convert, true)) continue;
            ItemStack removing = input.clone();
            removing.setAmount(convert.getAmount());
            p.getInventory().removeItem(new ItemStack[]{removing});
            return true;
        }
        return false;
    }

    private void generateLiquid(@Nonnull Block block, boolean water) {
        if (block.getType() == (water ? Material.WATER : Material.LAVA)) {
            this.addLiquidLevel(block, water);
        } else if (block.getType() == (water ? Material.LAVA : Material.WATER)) {
            int level = ((Levelled)block.getBlockData()).getLevel();
            block.setType(level == 0 || level == 8 ? Material.OBSIDIAN : Material.STONE);
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.0f);
        } else {
            SlimefunPlugin.runSync(() -> this.placeLiquid(block, water), 50L);
        }
    }

    private void addLiquidLevel(@Nonnull Block block, boolean water) {
        int level = ((Levelled)block.getBlockData()).getLevel();
        if (level > 7) {
            level -= 8;
        }
        if (level == 0) {
            block.getWorld().playSound(block.getLocation(), water ? Sound.ENTITY_PLAYER_SPLASH : Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
        } else {
            int finalLevel = 7 - level;
            SlimefunPlugin.runSync(() -> this.runPostTask(block, water ? Sound.ENTITY_PLAYER_SPLASH : Sound.BLOCK_LAVA_POP, finalLevel), 50L);
        }
    }

    private void placeLiquid(@Nonnull Block block, boolean water) {
        if (block.getType() == Material.AIR || block.getType() == Material.CAVE_AIR || block.getType() == Material.VOID_AIR) {
            block.setType(water ? Material.WATER : Material.LAVA);
        } else {
            if (water && block.getBlockData() instanceof Waterlogged) {
                Waterlogged wl = (Waterlogged)block.getBlockData();
                wl.setWaterlogged(true);
                block.setBlockData((BlockData)wl, false);
                block.getWorld().playSound(block.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f);
                return;
            }
            if (BlockStorage.hasBlockInfo(block)) {
                BlockStorage.clearBlockInfo(block);
            }
        }
        this.runPostTask(block, water ? Sound.ENTITY_PLAYER_SPLASH : Sound.BLOCK_LAVA_POP, 1);
    }

    @ParametersAreNonnullByDefault
    private void runPostTask(Block block, Sound sound, int times) {
        if (!(block.getBlockData() instanceof Levelled)) {
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_METAL_BREAK, 1.0f, 1.0f);
            return;
        }
        block.getWorld().playSound(block.getLocation(), sound, 1.0f, 1.0f);
        int level = 8 - times;
        Levelled le = (Levelled)block.getBlockData();
        le.setLevel(level);
        block.setBlockData((BlockData)le, false);
        if (times < 8) {
            SlimefunPlugin.runSync(() -> this.runPostTask(block, sound, times + 1), 50L);
        } else {
            block.getWorld().playSound(block.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f);
        }
    }
}

