/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.gps;

import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ChatComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ClickEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.CustomBookInterface;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.HoverEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ElevatorPlate
extends SimpleSlimefunItem<BlockUseHandler> {
    private static final String DATA_KEY = "floor";
    private final Set<UUID> users = new HashSet<UUID>();

    public ElevatorPlate(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        super(category, item, recipeType, recipe, recipeOutput);
        this.addItemHandler(this.onPlace());
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                Block b = e.getBlock();
                BlockStorage.addBlockInfo(b, ElevatorPlate.DATA_KEY, "&rFloor #0");
                BlockStorage.addBlockInfo(b, "owner", e.getPlayer().getUniqueId().toString());
            }
        };
    }

    @Nonnull
    public Set<UUID> getUsers() {
        return this.users;
    }

    @Override
    public BlockUseHandler getItemHandler() {
        return e -> {
            Block b = e.getClickedBlock().get();
            if (BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(e.getPlayer().getUniqueId().toString())) {
                this.openEditor(e.getPlayer(), b);
            }
        };
    }

    @Nonnull
    public List<Block> getFloors(@Nonnull Block b) {
        LinkedList<Block> floors = new LinkedList<Block>();
        for (int y = b.getWorld().getMaxHeight(); y > 0; --y) {
            if (y == b.getY()) {
                floors.add(b);
                continue;
            }
            Block block = b.getWorld().getBlockAt(b.getX(), y, b.getZ());
            if (block.getType() != this.getItem().getType() || !BlockStorage.check(block, this.getID())) continue;
            floors.add(block);
        }
        return floors;
    }

    @ParametersAreNonnullByDefault
    public void openInterface(Player p, Block b) {
        if (this.users.remove(p.getUniqueId())) {
            return;
        }
        List<Block> floors = this.getFloors(b);
        if (floors.size() < 2) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.no-destinations", true);
        } else {
            this.openFloorSelector(b, floors, p);
        }
    }

    @ParametersAreNonnullByDefault
    private void openFloorSelector(Block b, List<Block> floors, Player p) {
        CustomBookInterface book = new CustomBookInterface((Plugin)SlimefunPlugin.instance());
        ChatComponent page = null;
        for (int i = 0; i < floors.size(); ++i) {
            ChatComponent line;
            if (i % 10 == 0) {
                if (page != null) {
                    book.addPage(page);
                }
                page = new ChatComponent(ChatColors.color(SlimefunPlugin.getLocalization().getMessage(p, "machines.ELEVATOR.pick-a-floor")) + "\n");
            }
            Block block = floors.get(i);
            String floor = ChatColors.color(BlockStorage.getLocationInfo(block.getLocation(), DATA_KEY));
            if (block.getY() == b.getY()) {
                line = new ChatComponent("\n" + ChatColor.GRAY + "> " + (floors.size() - i) + ". " + ChatColor.BLACK + floor);
                line.setHoverEvent(new HoverEvent(ChatColors.color(SlimefunPlugin.getLocalization().getMessage(p, "machines.ELEVATOR.current-floor")), "", ChatColor.WHITE + floor, ""));
            } else {
                line = new ChatComponent("\n" + ChatColor.GRAY + (floors.size() - i) + ". " + ChatColor.BLACK + floor);
                line.setHoverEvent(new HoverEvent(ChatColors.color(SlimefunPlugin.getLocalization().getMessage(p, "machines.ELEVATOR.click-to-teleport")), "", ChatColor.WHITE + floor, ""));
                line.setClickEvent(new ClickEvent(new NamespacedKey((Plugin)SlimefunPlugin.instance(), DATA_KEY + i), player -> this.teleport((Player)player, floor, block)));
            }
            page.append(line);
        }
        if (page != null) {
            book.addPage(page);
        }
        book.open(p);
    }

    @ParametersAreNonnullByDefault
    private void teleport(Player player, String floorName, Block target) {
        SlimefunPlugin.runSync(() -> {
            this.users.add(player.getUniqueId());
            float yaw = player.getEyeLocation().getYaw() + 180.0f;
            if (yaw > 180.0f) {
                yaw = -180.0f + (yaw - 180.0f);
            }
            Location destination = new Location(player.getWorld(), (double)target.getX() + 0.5, (double)target.getY() + 0.4, (double)target.getZ() + 0.5, yaw, player.getEyeLocation().getPitch());
            PaperLib.teleportAsync((Entity)player, destination).thenAccept(teleported -> {
                if (teleported.booleanValue()) {
                    player.sendTitle(ChatColor.WHITE + ChatColors.color(floorName), null, 20, 60, 20);
                }
            });
        });
    }

    @ParametersAreNonnullByDefault
    public void openEditor(Player p, Block b) {
        ChestMenu menu = new ChestMenu("Elevator Settings");
        menu.addItem(4, (ItemStack)new CustomItem(Material.NAME_TAG, "&7Floor Name &e(Click to edit)", "", "&r" + ChatColors.color(BlockStorage.getLocationInfo(b.getLocation(), DATA_KEY))));
        menu.addMenuClickHandler(4, (pl, slot, item, action) -> {
            pl.closeInventory();
            pl.sendMessage("");
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.enter-name");
            pl.sendMessage("");
            ChatUtils.awaitInput(pl, message -> {
                BlockStorage.addBlockInfo(b, DATA_KEY, message.replace('\u00a7', '&'));
                pl.sendMessage("");
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.named", msg -> msg.replace("%floor%", (CharSequence)message));
                pl.sendMessage("");
                this.openEditor(pl, b);
            });
            return false;
        });
        menu.open(new Player[]{p});
    }
}

