/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import org.apache.commons.lang.Validate;

public enum MinecraftVersion {
    MINECRAFT_1_13("1.13.x"),
    MINECRAFT_1_14("1.14.x"),
    MINECRAFT_1_15("1.15.x"),
    MINECRAFT_1_16("1.16.x"),
    UNKNOWN("Unknown"),
    UNIT_TEST("Unit Test Environment");

    public static final MinecraftVersion[] values;
    private final String name;
    private final String prefix;

    private MinecraftVersion(String name) {
        this.name = name;
        this.prefix = this.name().replace("MINECRAFT_", "v") + '_';
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(String version) {
        Validate.notNull((Object)version, (String)"The input version must not be null!");
        return version.startsWith(this.prefix);
    }

    public boolean isAtLeast(MinecraftVersion version) {
        Validate.notNull((Object)((Object)version), (String)"A Minecraft version cannot be null!");
        if (this == UNKNOWN) {
            return false;
        }
        return this.ordinal() >= version.ordinal();
    }

    public boolean isBefore(MinecraftVersion version) {
        Validate.notNull((Object)((Object)version), (String)"A Minecraft version cannot be null!");
        if (this == UNKNOWN) {
            return true;
        }
        return version.ordinal() > this.ordinal();
    }

    static {
        values = MinecraftVersion.values();
    }
}

