/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.data.ComputedOptional;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlayerRightClickEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final PlayerInteractEvent event;
    private final Player player;
    private final Optional<ItemStack> itemStack;
    private final Optional<Block> clickedBlock;
    private final EquipmentSlot hand;
    private final BlockFace face;
    private ComputedOptional<SlimefunItem> slimefunItem = ComputedOptional.createNew();
    private ComputedOptional<SlimefunItem> slimefunBlock = ComputedOptional.createNew();
    private Event.Result itemResult = Event.Result.DEFAULT;
    private Event.Result blockResult = Event.Result.DEFAULT;

    public PlayerRightClickEvent(@Nonnull PlayerInteractEvent e) {
        this.event = e;
        this.player = e.getPlayer();
        this.clickedBlock = Optional.ofNullable(e.getClickedBlock());
        this.face = e.getBlockFace();
        this.hand = e.getHand();
        this.itemStack = e.getItem() == null || e.getItem().getType() == Material.AIR || e.getItem().getAmount() == 0 ? Optional.empty() : Optional.of(e.getItem());
    }

    @Nonnull
    public PlayerInteractEvent getInteractEvent() {
        return this.event;
    }

    @Nonnull
    public Player getPlayer() {
        return this.player;
    }

    @Nonnull
    public ItemStack getItem() {
        return this.itemStack.orElse(new ItemStack(Material.AIR));
    }

    @Nonnull
    public EquipmentSlot getHand() {
        return this.hand;
    }

    @Nonnull
    public Optional<Block> getClickedBlock() {
        return this.clickedBlock;
    }

    @Nonnull
    public BlockFace getClickedFace() {
        return this.face;
    }

    @Nonnull
    public Optional<SlimefunItem> getSlimefunItem() {
        if (!this.slimefunItem.isComputed()) {
            if (this.itemStack.isPresent()) {
                this.slimefunItem.compute(SlimefunItem.getByItem(this.itemStack.get()));
            } else {
                this.slimefunItem = ComputedOptional.empty();
            }
        }
        return this.slimefunItem.getAsOptional();
    }

    @Nonnull
    public Optional<SlimefunItem> getSlimefunBlock() {
        if (!this.slimefunBlock.isComputed()) {
            if (this.clickedBlock.isPresent()) {
                this.slimefunBlock.compute(BlockStorage.check(this.clickedBlock.get()));
            } else {
                this.slimefunBlock = ComputedOptional.empty();
            }
        }
        return this.slimefunBlock.getAsOptional();
    }

    public void cancel() {
        this.itemResult = Event.Result.DENY;
        this.blockResult = Event.Result.DENY;
    }

    @Nonnull
    public Event.Result useItem() {
        return this.itemResult;
    }

    @Nonnull
    public Event.Result useBlock() {
        return this.blockResult;
    }

    public void setUseItem(@Nonnull Event.Result result) {
        Validate.notNull((Object)result, (String)"Result cannot be null");
        this.itemResult = result;
    }

    public void setUseBlock(@Nonnull Event.Result result) {
        Validate.notNull((Object)result, (String)"Result cannot be null");
        this.blockResult = result;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return PlayerRightClickEvent.getHandlerList();
    }
}

