/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.MagicianTalisman;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.Talisman;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.TalismanEnchantment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TalismanListener
implements Listener {
    private final int[] armorSlots = new int[]{39, 38, 37, 36};

    public TalismanListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamageGet(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            if (e.getCause() == EntityDamageEvent.DamageCause.LAVA) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_LAVA);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WATER);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.FALL) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_ANGEL);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.FIRE) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_FIRE);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_KNIGHT);
                Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WARRIOR);
            }
            if (e.getCause() == EntityDamageEvent.DamageCause.PROJECTILE && e instanceof EntityDamageByEntityEvent) {
                this.onProjectileDamage((EntityDamageByEntityEvent)e);
            }
        }
    }

    private void onProjectileDamage(@Nonnull EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Projectile && !(e.getDamager() instanceof Trident)) {
            Projectile projectile = (Projectile)e.getDamager();
            if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WHIRLWIND)) {
                Player p = (Player)e.getEntity();
                this.returnProjectile(p, projectile);
            }
        }
    }

    private void returnProjectile(@Nonnull Player p, @Nonnull Projectile projectile) {
        Vector direction = p.getEyeLocation().getDirection().multiply(2.0);
        Location loc = p.getEyeLocation().add(direction.getX(), direction.getY(), direction.getZ());
        Projectile returnedProjectile = (Projectile)p.getWorld().spawnEntity(loc, projectile.getType());
        returnedProjectile.setShooter(projectile.getShooter());
        returnedProjectile.setVelocity(direction);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow firedArrow = (AbstractArrow)projectile;
            AbstractArrow returnedArrow = (AbstractArrow)returnedProjectile;
            returnedArrow.setDamage(firedArrow.getDamage());
            returnedArrow.setPickupStatus(firedArrow.getPickupStatus());
            returnedArrow.setPierceLevel(firedArrow.getPierceLevel());
        }
        projectile.remove();
    }

    @EventHandler(ignoreCancelled=true)
    public void onKill(EntityDeathEvent e) {
        if (e.getDrops().isEmpty() || e.getEntity().getKiller() == null) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (entity instanceof Player || entity instanceof ArmorStand) {
            return;
        }
        if (!entity.getCanPickupItems() && Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_HUNTER)) {
            Collection<ItemStack> extraDrops = this.getExtraDrops(e.getEntity(), e.getDrops());
            for (ItemStack drop : extraDrops) {
                if (drop == null || drop.getType() == Material.AIR) continue;
                e.getDrops().add(drop.clone());
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private Collection<ItemStack> getExtraDrops(LivingEntity entity, Collection<ItemStack> drops) {
        EntityEquipment equipment;
        ChestedHorse horse;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(drops);
        if (entity instanceof ChestedHorse && (horse = (ChestedHorse)entity).isCarryingChest()) {
            items.remove(new ItemStack(Material.CHEST));
            for (ItemStack item : horse.getInventory().getStorageContents()) {
                items.remove(item);
            }
        }
        if ((equipment = entity.getEquipment()) != null) {
            for (ItemStack item : equipment.getArmorContents()) {
                items.remove(item);
            }
            items.remove(equipment.getItemInMainHand());
            items.remove(equipment.getItemInOffHand());
        }
        return items;
    }

    @EventHandler
    public void onItemBreak(PlayerItemBreakEvent e) {
        if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_ANVIL)) {
            ItemStack item;
            ItemMeta meta;
            PlayerInventory inv = e.getPlayer().getInventory();
            int slot = inv.getHeldItemSlot();
            if (!inv.getItem(inv.getHeldItemSlot()).equals((Object)e.getBrokenItem())) {
                for (int s : this.armorSlots) {
                    if (!e.getBrokenItem().equals((Object)inv.getItem(s))) continue;
                    slot = s;
                    break;
                }
            }
            if ((meta = (item = e.getBrokenItem().clone()).getItemMeta()) instanceof Damageable) {
                ((Damageable)meta).setDamage(0);
            }
            item.setItemMeta(meta);
            int itemSlot = slot;
            SlimefunPlugin.runSync(() -> inv.setItem(itemSlot, item), 1L);
        }
    }

    @EventHandler
    public void onSprint(PlayerToggleSprintEvent e) {
        if (e.isSprinting()) {
            Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_TRAVELLER);
        }
    }

    @EventHandler
    public void onEnchant(EnchantItemEvent e) {
        MagicianTalisman talisman;
        TalismanEnchantment enchantment;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_MAGICIAN) && (enchantment = (talisman = (MagicianTalisman)SlimefunItems.TALISMAN_MAGICIAN.getItem()).getRandomEnchantment(e.getItem())) != null) {
            e.getEnchantsToAdd().put(enchantment.getEnchantment(), enchantment.getLevel());
        }
        if (!e.getEnchantsToAdd().containsKey(Enchantment.SILK_TOUCH) && Enchantment.LOOT_BONUS_BLOCKS.canEnchantItem(e.getItem()) && Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_WIZARD)) {
            Set enchantments = e.getEnchantsToAdd().keySet();
            for (Enchantment enchantment2 : enchantments) {
                if (((Random)random).nextInt(100) >= 40) continue;
                e.getEnchantsToAdd().put(enchantment2, ((Random)random).nextInt(3) + 1);
            }
            e.getEnchantsToAdd().put(Enchantment.LOOT_BONUS_BLOCKS, ((Random)random).nextInt(3) + 3);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockDropItems(BlockDropItemEvent e) {
        ItemStack item;
        Material type = e.getBlockState().getType();
        if (type.name().endsWith("_ORE") && (item = e.getPlayer().getInventory().getItemInMainHand()).getType() != Material.AIR && item.getAmount() > 0 && !item.containsEnchantment(Enchantment.SILK_TOUCH)) {
            List drops = e.getItems();
            if (Talisman.checkFor((Event)e, SlimefunItems.TALISMAN_MINER)) {
                int dropAmount = this.getAmountWithFortune(type, item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS));
                boolean doubledDrops = false;
                for (Item drop : drops) {
                    ItemStack droppedItem = drop.getItemStack();
                    if (droppedItem.getType().isBlock()) continue;
                    int amount = Math.max(1, dropAmount * 2 - droppedItem.getAmount());
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), (ItemStack)new CustomItem(droppedItem, amount));
                    doubledDrops = true;
                }
                if (doubledDrops) {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.talisman.miner", true);
                }
            }
        }
    }

    private int getAmountWithFortune(@Nonnull Material type, int fortuneLevel) {
        if (fortuneLevel > 0) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int amount = ((Random)random).nextInt(fortuneLevel + 2) - 1;
            amount = Math.max(amount, 1);
            amount = (type == Material.LAPIS_ORE ? 4 + ((Random)random).nextInt(5) : 1) * (amount + 1);
            return amount;
        }
        return 1;
    }
}

