/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class BlockMenuPreset
extends ChestMenu {
    private final Set<Integer> occupiedSlots = new HashSet<Integer>();
    private final String inventoryTitle;
    private final String id;
    private int size = -1;
    private final boolean universal;
    private boolean locked;
    private ItemManipulationEvent event;

    public BlockMenuPreset(@Nonnull String id, @Nonnull String title) {
        this(id, title, false);
    }

    public BlockMenuPreset(@Nonnull String id, @Nonnull String title, boolean universal) {
        super(title);
        Validate.notNull((Object)id, (String)"You need to specify an id!");
        this.id = id;
        this.inventoryTitle = title;
        this.universal = universal;
        this.init();
        SlimefunPlugin.getRegistry().getMenuPresets().put(id, this);
    }

    private void checkIfLocked() {
        if (this.locked) {
            throw new UnsupportedOperationException("You cannot modify the BlockMenuPreset anymore, modify the individual instances instead.");
        }
    }

    public abstract void init();

    public abstract boolean canOpen(@Nonnull Block var1, @Nonnull Player var2);

    public abstract int[] getSlotsAccessedByItemTransport(ItemTransportFlow var1);

    @Deprecated
    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    @Nullable
    protected ItemStack onItemStackChange(@Nonnull DirtyChestMenu menu, int slot, @Nullable ItemStack previous, @Nullable ItemStack next) {
        return next;
    }

    public void newInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
    }

    public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
        return this.getSlotsAccessedByItemTransport(flow);
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        throw new UnsupportedOperationException("BlockMenuPreset does not support this method.");
    }

    public ChestMenu addItem(int slot, @Nullable ItemStack item) {
        this.checkIfLocked();
        this.occupiedSlots.add(slot);
        return super.addItem(slot, item);
    }

    public ChestMenu addMenuClickHandler(int slot, ChestMenu.MenuClickHandler handler) {
        this.checkIfLocked();
        return super.addMenuClickHandler(slot, handler);
    }

    @Nonnull
    public ChestMenu setSize(int size) {
        this.checkIfLocked();
        if (size % 9 == 0 && size >= 0 && size < 55) {
            this.size = size;
            return this;
        }
        throw new IllegalArgumentException("The size of a BlockMenuPreset must be a multiple of 9 and within the bounds 0-54, received: " + size);
    }

    public int getSize() {
        return this.size;
    }

    private boolean isSizeAutomaticallyInferred() {
        return this.size == -1;
    }

    public String getTitle() {
        return this.inventoryTitle;
    }

    public boolean isUniversal() {
        return this.universal;
    }

    @Nonnull
    public Set<Integer> getPresetSlots() {
        return this.occupiedSlots;
    }

    @Nonnull
    public Set<Integer> getInventorySlots() {
        HashSet<Integer> emptySlots = new HashSet<Integer>();
        if (this.isSizeAutomaticallyInferred()) {
            for (int i = 0; i < this.toInventory().getSize(); ++i) {
                if (this.occupiedSlots.contains(i)) continue;
                emptySlots.add(i);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.occupiedSlots.contains(i)) continue;
                emptySlots.add(i);
            }
        }
        return emptySlots;
    }

    protected void clone(@Nonnull DirtyChestMenu menu) {
        menu.setPlayerInventoryClickable(true);
        for (int slot : this.occupiedSlots) {
            menu.addItem(slot, this.getItemInSlot(slot));
        }
        if (this.size > -1) {
            menu.addItem(this.size - 1, null);
        }
        if (menu instanceof BlockMenu) {
            BlockMenu blockMenu = (BlockMenu)menu;
            this.newInstance(blockMenu, blockMenu.getLocation());
        }
        for (int slot = 0; slot < 54; ++slot) {
            if (this.getMenuClickHandler(slot) == null) continue;
            menu.addMenuClickHandler(slot, this.getMenuClickHandler(slot));
        }
        menu.addMenuOpeningHandler(this.getMenuOpeningHandler());
        menu.addMenuCloseHandler(this.getMenuCloseHandler());
        menu.registerEvent(this.event);
    }

    public void newInstance(@Nonnull BlockMenu menu, @Nonnull Location l) {
        Validate.notNull((Object)l, (String)"Cannot create a new BlockMenu without a Location");
        SlimefunPlugin.runSync(() -> {
            this.locked = true;
            try {
                this.newInstance(menu, l.getBlock());
            }
            catch (Exception | LinkageError x) {
                this.getSlimefunItem().error("An Error occurred while trying to create a BlockMenu", x);
            }
        });
    }

    @Nonnull
    public String getID() {
        return this.id;
    }

    @Nonnull
    public SlimefunItem getSlimefunItem() {
        return SlimefunItem.getByID(this.id);
    }

    @Nullable
    public static BlockMenuPreset getPreset(String id) {
        return id == null ? null : SlimefunPlugin.getRegistry().getMenuPresets().get(id);
    }

    public static boolean isInventory(String id) {
        return SlimefunPlugin.getRegistry().getMenuPresets().containsKey(id);
    }

    public static boolean isUniversalInventory(String id) {
        BlockMenuPreset preset = SlimefunPlugin.getRegistry().getMenuPresets().get(id);
        return preset != null && preset.isUniversal();
    }
}

