/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class TickerTask
implements Runnable {
    private final Map<Location, Location> movingQueue = new ConcurrentHashMap<Location, Location>();
    private final Map<Location, Boolean> deletionQueue = new ConcurrentHashMap<Location, Boolean>();
    private final Map<BlockPosition, Integer> bugs = new ConcurrentHashMap<BlockPosition, Integer>();
    private int tickRate;
    private boolean halted = false;
    private boolean running = false;

    public void start(@Nonnull SlimefunPlugin plugin) {
        this.tickRate = SlimefunPlugin.getCfg().getInt("URID.custom-ticker-delay");
        BukkitScheduler scheduler = plugin.getServer().getScheduler();
        scheduler.runTaskTimerAsynchronously((Plugin)plugin, (Runnable)this, 100L, (long)this.tickRate);
    }

    public void reset() {
        this.running = false;
    }

    @Override
    public void run() {
        try {
            if (this.running) {
                return;
            }
            this.running = true;
            SlimefunPlugin.getProfiler().start();
            HashSet<BlockTicker> tickers = new HashSet<BlockTicker>();
            Iterator<Map.Entry<Location, Boolean>> removals = this.deletionQueue.entrySet().iterator();
            while (removals.hasNext()) {
                Map.Entry<Location, Boolean> entry = removals.next();
                BlockStorage.deleteLocationInfoUnsafely(entry.getKey(), (Boolean)entry.getValue());
                removals.remove();
            }
            if (!this.halted) {
                for (String chunk : BlockStorage.getTickingChunks()) {
                    this.tickChunk(tickers, chunk);
                }
            }
            Iterator<Map.Entry<Location, Location>> moves = this.movingQueue.entrySet().iterator();
            while (moves.hasNext()) {
                Map.Entry<Location, Location> entry = moves.next();
                BlockStorage.moveLocationInfoUnsafely(entry.getKey(), entry.getValue());
                moves.remove();
            }
            for (BlockTicker ticker : tickers) {
                ticker.startNewTick();
            }
            this.reset();
            SlimefunPlugin.getProfiler().stop();
        }
        catch (Exception | LinkageError x) {
            Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Exception was caught while ticking the Block Tickers Task for Slimefun v" + SlimefunPlugin.getVersion());
            this.reset();
        }
    }

    private void tickChunk(@Nonnull Set<BlockTicker> tickers, @Nonnull String chunk) {
        try {
            Set<Location> locations = BlockStorage.getTickingLocations(chunk);
            String[] components = PatternUtils.SEMICOLON.split(chunk);
            World world = Bukkit.getWorld((String)components[0]);
            int x = Integer.parseInt(components[components.length - 2]);
            int z = Integer.parseInt(components[components.length - 1]);
            if (world != null && world.isChunkLoaded(x, z)) {
                for (Location l : locations) {
                    this.tickLocation(tickers, l);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException x) {
            Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Exception has occurred while trying to parse Chunk: " + chunk);
        }
    }

    private void tickLocation(@Nonnull Set<BlockTicker> tickers, @Nonnull Location l) {
        Config data = BlockStorage.getLocationInfo(l);
        SlimefunItem item = SlimefunItem.getByID(data.getString("id"));
        if (item != null && item.getBlockTicker() != null) {
            try {
                if (item.getBlockTicker().isSynchronized()) {
                    SlimefunPlugin.getProfiler().scheduleEntries(1);
                    item.getBlockTicker().update();
                    SlimefunPlugin.runSync(() -> {
                        Block b = l.getBlock();
                        this.tickBlock(l, b, item, data, System.nanoTime());
                    });
                } else {
                    long timestamp = SlimefunPlugin.getProfiler().newEntry();
                    item.getBlockTicker().update();
                    Block b = l.getBlock();
                    this.tickBlock(l, b, item, data, timestamp);
                }
                tickers.add(item.getBlockTicker());
            }
            catch (Exception x) {
                this.reportErrors(l, item, x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParametersAreNonnullByDefault
    private void tickBlock(Location l, Block b, SlimefunItem item, Config data, long timestamp) {
        try {
            item.getBlockTicker().tick(b, item, data);
        }
        catch (Exception | LinkageError x) {
            this.reportErrors(l, item, x);
        }
        finally {
            SlimefunPlugin.getProfiler().closeEntry(l, item, timestamp);
        }
    }

    @ParametersAreNonnullByDefault
    private void reportErrors(Location l, SlimefunItem item, Throwable x) {
        BlockPosition position = new BlockPosition(l);
        int errors = this.bugs.getOrDefault(position, 0) + 1;
        if (errors == 1) {
            new ErrorReport<Throwable>(x, l, item);
            this.bugs.put(position, errors);
        } else if (errors == 4) {
            Slimefun.getLogger().log(Level.SEVERE, "X: {0} Y: {1} Z: {2} ({3})", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ(), item.getID()});
            Slimefun.getLogger().log(Level.SEVERE, "has thrown 4 error messages in the last 4 Ticks, the Block has been terminated.");
            Slimefun.getLogger().log(Level.SEVERE, "Check your /plugins/Slimefun/error-reports/ folder for details.");
            Slimefun.getLogger().log(Level.SEVERE, " ");
            this.bugs.remove(position);
            BlockStorage.deleteLocationInfoUnsafely(l, true);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance(), () -> l.getBlock().setType(Material.AIR));
        } else {
            this.bugs.put(position, errors);
        }
    }

    public boolean isHalted() {
        return this.halted;
    }

    public void halt() {
        this.halted = true;
    }

    @ParametersAreNonnullByDefault
    public void queueMove(Location from, Location to) {
        this.movingQueue.put(from, to);
    }

    @ParametersAreNonnullByDefault
    public void queueDelete(Location l, boolean destroy) {
        this.deletionQueue.put(l, destroy);
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public String toString() {
        return "TickerTask {\n     HALTED = " + this.halted + "\n     move = " + this.movingQueue + "\n     delete = " + this.deletionQueue + "}";
    }
}

