/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BasicResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Proxy;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.DefaultFactory;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.RequestConfigFactory;
import java.util.function.Function;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

abstract class BaseApacheClient {
    protected RequestConfigFactory configFactory = new DefaultFactory();

    BaseApacheClient() {
    }

    protected CredentialsProvider toApacheCreds(Proxy proxy) {
        if (proxy != null && proxy.isAuthenticated()) {
            BasicCredentialsProvider proxyCreds = new BasicCredentialsProvider();
            proxyCreds.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword()));
            return proxyCreds;
        }
        return null;
    }

    protected <T> HttpResponse<T> transformBody(Function<RawResponse, HttpResponse<T>> transformer, RawResponse rr) {
        try {
            return transformer.apply(rr);
        }
        catch (RuntimeException e) {
            String originalBody = this.recoverBody(rr);
            return new BasicResponse(rr, originalBody, e);
        }
    }

    private String recoverBody(RawResponse rr) {
        try {
            return rr.getContentAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setConfigFactory(RequestConfigFactory configFactory) {
        this.configFactory = configFactory;
    }
}

