/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BaseResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.MonitoringInputStream;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.ProgressMonitor;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileResponse
extends BaseResponse<File> {
    private File body;

    public FileResponse(RawResponse r, String path, ProgressMonitor downloadMonitor) {
        super(r);
        try {
            Path target = Paths.get(path, new String[0]);
            InputStream content = this.getContent(r, downloadMonitor, target);
            Files.copy(content, target, new CopyOption[0]);
            this.body = target.toFile();
        }
        catch (IOException e) {
            throw new UnirestException(e);
        }
    }

    private InputStream getContent(RawResponse r, ProgressMonitor downloadMonitor, Path target) {
        if (downloadMonitor == null) {
            return r.getContent();
        }
        return new MonitoringInputStream(r.getContent(), downloadMonitor, target, r);
    }

    @Override
    public File getBody() {
        return this.body;
    }

    @Override
    protected String getRawBody() {
        return null;
    }
}

