/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BaseRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Body;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.BodyPart;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequestBody;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RequestBodyEntity;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UniByteArrayBody;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnibodyString;
import java.nio.charset.Charset;
import java.util.Optional;

class HttpRequestUniBody
extends BaseRequest<RequestBodyEntity>
implements RequestBodyEntity {
    private BodyPart body;
    private Charset charSet;

    HttpRequestUniBody(HttpRequestBody httpRequest) {
        super(httpRequest);
        this.charSet = httpRequest.getCharset();
    }

    @Override
    public RequestBodyEntity body(JsonNode jsonBody) {
        return this.body(jsonBody.toString());
    }

    @Override
    public RequestBodyEntity body(String bodyAsString) {
        this.body = new UnibodyString(bodyAsString, this.charSet);
        return this;
    }

    @Override
    public RequestBodyEntity body(byte[] bodyBytes) {
        this.body = new UniByteArrayBody(bodyBytes);
        return this;
    }

    @Override
    public RequestBodyEntity charset(Charset charset) {
        this.charSet = charset;
        return this;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.of(this);
    }

    @Override
    public Charset getCharset() {
        return this.charSet;
    }

    @Override
    public boolean isMultiPart() {
        return false;
    }

    @Override
    public boolean isEntityBody() {
        return true;
    }

    @Override
    public BodyPart uniPart() {
        return this.body;
    }
}

