/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kong.unirest.Body;
import kong.unirest.BodyPart;
import kong.unirest.HttpRequest;
import kong.unirest.apache.MonitoringFileBody;
import kong.unirest.apache.MonitoringStreamBody;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;

class ApacheBodyMapper {
    private final HttpRequest request;

    ApacheBodyMapper(HttpRequest request) {
        this.request = request;
    }

    HttpEntity apply() {
        Optional<Body> body = this.request.getBody();
        return body.map(this::applyBody).orElseGet(BasicHttpEntity::new);
    }

    private HttpEntity applyBody(Body o) {
        if (o.isEntityBody()) {
            return this.mapToUniBody(o);
        }
        return this.mapToMultipart(o);
    }

    private HttpEntity mapToUniBody(Body b) {
        BodyPart bodyPart = b.uniPart();
        if (bodyPart == null) {
            return new StringEntity("", StandardCharsets.UTF_8);
        }
        if (String.class.isAssignableFrom(bodyPart.getPartType())) {
            return new StringEntity((String)bodyPart.getValue(), b.getCharset());
        }
        return new ByteArrayEntity((byte[])bodyPart.getValue());
    }

    private HttpEntity mapToMultipart(Body body) {
        if (body.isMultiPart()) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(body.getCharset());
            builder.setMode(HttpMultipartMode.valueOf(body.getMode().name()));
            for (BodyPart key : body.multiParts()) {
                builder.addPart(key.getName(), this.apply(key, body));
            }
            return builder.build();
        }
        return new UrlEncodedFormEntity(ApacheBodyMapper.getList(body.multiParts()), body.getCharset());
    }

    private ContentBody apply(BodyPart value, Body body) {
        if (this.is(value, File.class)) {
            return this.toFileBody(value, body);
        }
        if (this.is(value, InputStream.class)) {
            return this.toInputStreamBody(value, body);
        }
        if (this.is(value, byte[].class)) {
            return this.toByteArrayBody(value);
        }
        return this.toStringBody(value);
    }

    private ContentBody toFileBody(BodyPart value, Body body) {
        File file = (File)value.getValue();
        return new MonitoringFileBody(value.getName(), file, this.toApacheType(value.getContentType()), body.getMonitor());
    }

    private ContentBody toInputStreamBody(BodyPart value, Body body) {
        InputStream part = (InputStream)value.getValue();
        return new MonitoringStreamBody(part, this.toApacheType(value.getContentType()), value.getFileName(), value.getName(), body.getMonitor());
    }

    private ContentBody toByteArrayBody(BodyPart value) {
        byte[] part = (byte[])value.getValue();
        return new ByteArrayBody(part, this.toApacheType(value.getContentType()), value.getFileName());
    }

    private ContentBody toStringBody(BodyPart value) {
        return new StringBody(String.valueOf(value.getValue()), this.toApacheType(value.getContentType()));
    }

    private boolean is(BodyPart value, Class<?> cls) {
        return cls.isAssignableFrom(value.getPartType());
    }

    private ContentType toApacheType(String type) {
        return ContentType.parse(type);
    }

    static List<NameValuePair> getList(Collection<BodyPart> parameters) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (BodyPart entry : parameters) {
            result.add(new BasicNameValuePair(entry.getName(), entry.getValue().toString()));
        }
        return result;
    }
}

