/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.MetricContext;
import kong.unirest.RawResponse;
import kong.unirest.apache.ApacheResponse;
import kong.unirest.apache.BaseApacheClient;
import kong.unirest.apache.RequestConfigFactory;
import kong.unirest.apache.RequestOptions;
import kong.unirest.apache.RequestPrep;
import kong.unirest.apache.SecurityConfig;
import kong.unirest.apache.Util;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheClient
extends BaseApacheClient
implements Client {
    private final HttpClient client;
    private final Config config;
    private final SecurityConfig security;
    private final PoolingHttpClientConnectionManager manager;
    private boolean hookset;

    public ApacheClient(Config config) {
        this.config = config;
        this.security = new SecurityConfig(config);
        this.manager = this.security.createManager();
        HttpClientBuilder cb = HttpClients.custom().setDefaultRequestConfig(RequestOptions.toRequestConfig(config)).setDefaultCredentialsProvider(this.toApacheCreds(config.getProxy())).setConnectionManager(this.manager).evictIdleConnections(30L, TimeUnit.SECONDS).useSystemProperties();
        this.setOptions(cb);
        this.client = cb.build();
    }

    @Deprecated
    public ApacheClient(HttpClient httpClient, Config config, PoolingHttpClientConnectionManager clientManager) {
        this.client = httpClient;
        this.security = new SecurityConfig(config);
        this.config = config;
        this.manager = clientManager;
    }

    public ApacheClient(HttpClient httpClient, Config config) {
        this.client = httpClient;
        this.config = config;
        this.security = new SecurityConfig(config);
        this.manager = null;
    }

    private void setOptions(HttpClientBuilder cb) {
        this.security.configureSecurity(cb);
        if (!this.config.isAutomaticRetries()) {
            cb.disableAutomaticRetries();
        }
        if (!this.config.isRequestCompressionOn()) {
            cb.disableContentCompression();
        }
        if (this.config.useSystemProperties()) {
            cb.useSystemProperties();
        }
        if (!this.config.getFollowRedirects()) {
            cb.disableRedirectHandling();
        }
        if (!this.config.getEnabledCookieManagement()) {
            cb.disableCookieManagement();
        }
        this.config.getInterceptor().stream().forEach(cb::addInterceptorFirst);
        if (this.config.shouldAddShutdownHook()) {
            this.registerShutdownHook();
        }
    }

    @Override
    public void registerShutdownHook() {
        if (!this.hookset) {
            this.hookset = true;
            Runtime.getRuntime().addShutdownHook(new Thread(this::close, "Unirest Apache Client Shutdown Hook"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer) {
        HttpRequestSummary reqSum = request.toSummary();
        this.config.getUniInterceptor().onRequest(request, this.config);
        HttpRequestBase requestObj = new RequestPrep(request, this.config, false).prepare(this.configFactory);
        MetricContext metric = this.config.getMetric().begin(reqSum);
        try {
            org.apache.http.HttpResponse execute = this.client.execute(requestObj);
            ApacheResponse t = new ApacheResponse(execute, this.config);
            metric.complete(t.toSummary(), null);
            HttpResponse<T> httpResponse = this.transformBody(transformer, t);
            requestObj.releaseConnection();
            this.config.getUniInterceptor().onResponse(httpResponse, reqSum, this.config);
            HttpResponse<T> httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            metric.complete(null, e);
            HttpResponse<?> httpResponse = this.config.getUniInterceptor().onFail(e, reqSum, this.config);
            return httpResponse;
        }
        finally {
            requestObj.releaseConnection();
        }
    }

    @Override
    public HttpClient getClient() {
        return this.client;
    }

    public PoolingHttpClientConnectionManager getManager() {
        return this.manager;
    }

    @Override
    public Stream<Exception> close() {
        return Util.collectExceptions(Util.tryCast(this.client, CloseableHttpClient.class).map(c -> Util.tryDo(c, Closeable::close)).filter(Optional::isPresent).map(Optional::get), Util.tryDo(this.manager, m -> m.close()));
    }

    public static Builder builder(HttpClient baseClient) {
        return new Builder(baseClient);
    }

    public static class Builder
    implements Function<Config, Client> {
        private HttpClient baseClient;
        private RequestConfigFactory configFactory;

        public Builder(HttpClient baseClient) {
            this.baseClient = baseClient;
        }

        @Override
        public Client apply(Config config) {
            ApacheClient apacheClient = new ApacheClient(this.baseClient, config);
            if (this.configFactory != null) {
                apacheClient.setConfigFactory(this.configFactory);
            }
            return apacheClient;
        }

        public Builder withRequestConfig(RequestConfigFactory factory) {
            Objects.requireNonNull(factory);
            this.configFactory = factory;
            return this;
        }
    }
}

