/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.math.vectors;

import lombok.NonNull;

public class Vector2 {
    private double x;
    private double y;

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double distance(@NonNull Vector2 v) {
        if (v == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distanceSquared(@NonNull Vector2 v) {
        if (v == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        return (this.x - v.x) * (this.x - v.x) + (this.y - v.y) * (this.y - v.y);
    }

    public double dotProduct(@NonNull Vector2 v) {
        if (v == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        return this.x * v.x + this.y * v.y;
    }

    public void normalize() {
        double length = this.magnitude();
        this.x /= length;
        this.y /= length;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector2)) {
            return false;
        }
        Vector2 other = (Vector2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        return Double.compare(this.getY(), other.getY()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vector2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        return result;
    }

    public String toString() {
        return "Vector2(x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

