/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.exceptions.PrematureCodeException;
import io.github.thebusybiscuit.slimefun4.api.exceptions.WrongItemStackException;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.item.ImmutableItemMeta;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SlimefunItemStack
extends CustomItem {
    private String id;
    private ImmutableItemMeta immutableMeta;
    private boolean locked = false;
    private String texture = null;

    public SlimefunItemStack(String id, Material type, String name, String ... lore) {
        super(type, name, lore);
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, Material type, Color color, String name, String ... lore) {
        super(new ItemStack(type), color, name, lore);
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, Color color, PotionEffect effect, String name, String ... lore) {
        super(Material.POTION, (ItemMeta im) -> {
            if (name != null) {
                im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            if (lore.length > 0) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : lore) {
                    lines.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                im.setLore(lines);
            }
            if (im instanceof PotionMeta) {
                ((PotionMeta)im).setColor(color);
                ((PotionMeta)im).addCustomEffect(effect, true);
                if (effect.getType().equals((Object)PotionEffectType.SATURATION)) {
                    im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
                }
            }
        });
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, ItemStack item, String name, String ... lore) {
        super(item, name, lore);
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, ItemStack item) {
        super(item);
        this.setItemId(id);
    }

    public SlimefunItemStack(SlimefunItemStack item, int amount) {
        this(item.getItemId(), item);
        this.setAmount(amount);
    }

    public SlimefunItemStack(String id, ItemStack item, Consumer<ItemMeta> consumer) {
        super(item, consumer);
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, Material type, String name, Consumer<ItemMeta> consumer) {
        super(type, (ItemMeta meta) -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            consumer.accept((ItemMeta)meta);
        });
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, String texture, String name, String ... lore) {
        super(SlimefunItemStack.getSkull(id, texture), name, lore);
        this.texture = SlimefunItemStack.getTexture(id, texture);
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, HeadTexture head, String name, String ... lore) {
        this(id, head.getTexture(), name, lore);
    }

    public SlimefunItemStack(String id, String texture, String name, Consumer<ItemMeta> consumer) {
        super(SlimefunItemStack.getSkull(id, texture), (ItemMeta meta) -> {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            consumer.accept((ItemMeta)meta);
        });
        this.texture = SlimefunItemStack.getTexture(id, texture);
        this.setItemId(id);
    }

    public SlimefunItemStack(String id, String texture, Consumer<ItemMeta> consumer) {
        super(SlimefunItemStack.getSkull(id, texture), consumer);
        this.texture = SlimefunItemStack.getTexture(id, texture);
        this.setItemId(id);
    }

    private void setItemId(@Nonnull String id) {
        Validate.notNull((Object)id, (String)"The Item id must never be null!");
        Validate.isTrue((boolean)id.equals(id.toUpperCase(Locale.ROOT)), (String)"Slimefun Item Ids must be uppercase! (e.g. 'MY_ITEM_ID')");
        if (SlimefunPlugin.instance() == null) {
            throw new PrematureCodeException("A SlimefunItemStack must never be be created before your Plugin was enabled.");
        }
        this.id = id;
        ItemMeta meta = this.getItemMeta();
        SlimefunPlugin.getItemDataService().setItemData(meta, id);
        SlimefunPlugin.getItemTextureService().setTexture(meta, id);
        this.setItemMeta(meta);
    }

    @Nonnull
    public final String getItemId() {
        return this.id;
    }

    @Nullable
    public SlimefunItem getItem() {
        return SlimefunItem.getByID(this.id);
    }

    public <T extends SlimefunItem> T getItem(Class<T> type) {
        SlimefunItem item = this.getItem();
        return (T)(type.isInstance(item) ? (SlimefunItem)type.cast(item) : null);
    }

    public ImmutableItemMeta getImmutableMeta() {
        return this.immutableMeta;
    }

    public boolean setItemMeta(ItemMeta meta) {
        this.validate();
        this.immutableMeta = new ImmutableItemMeta(meta);
        return super.setItemMeta(meta);
    }

    public void setType(Material type) {
        this.validate();
        super.setType(type);
    }

    public void setAmount(int amount) {
        this.validate();
        super.setAmount(amount);
    }

    private void validate() {
        if (this.locked) {
            throw new WrongItemStackException(this.id + " is not mutable.");
        }
    }

    public void lock() {
        this.locked = true;
    }

    public ItemStack clone() {
        return new SlimefunItemStack(this.id, this);
    }

    public String toString() {
        return "SlimefunItemStack (" + this.id + (this.getAmount() > 1 ? " x " + this.getAmount() : "") + ')';
    }

    public Optional<String> getSkullTexture() {
        return Optional.ofNullable(this.texture);
    }

    public String getDisplayName() {
        if (this.immutableMeta == null) {
            return null;
        }
        return this.immutableMeta.getDisplayName().orElse(null);
    }

    private static ItemStack getSkull(String id, String texture) {
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        return SkullItem.fromBase64(SlimefunItemStack.getTexture(id, texture));
    }

    @Nonnull
    private static String getTexture(@Nonnull String id, @Nonnull String texture) {
        Validate.notNull((Object)id, (String)"The id cannot be null");
        Validate.notNull((Object)texture, (String)"The texture cannot be null");
        if (texture.startsWith("ey")) {
            return texture;
        }
        if (PatternUtils.ALPHANUMERIC.matcher(texture).matches()) {
            return Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + texture + "\"}}}").getBytes(StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException("The provided texture for Item \"" + id + "\" does not seem to be a valid texture String!");
    }
}

