/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands;

import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

class SlimefunTabCompleter
implements TabCompleter {
    private static final int MAX_SUGGESTIONS = 80;
    private final SlimefunCommand command;

    public SlimefunTabCompleter(@Nonnull SlimefunCommand command) {
        this.command = command;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            return this.createReturnList(this.command.getSubCommandNames(), args[0]);
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give")) {
                return this.createReturnList(this.getSlimefunItems(), args[2]);
            }
            if (args[0].equalsIgnoreCase("research")) {
                List<Research> researches = SlimefunPlugin.getRegistry().getResearches();
                LinkedList<String> suggestions = new LinkedList<String>();
                suggestions.add("all");
                suggestions.add("reset");
                for (Research research : researches) {
                    suggestions.add(research.getKey().toString().toLowerCase(Locale.ROOT));
                }
                return this.createReturnList(suggestions, args[2]);
            }
            return null;
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("give")) {
            return this.createReturnList(Arrays.asList("1", "2", "4", "8", "16", "32", "64"), args[3]);
        }
        return null;
    }

    @Nonnull
    private List<String> createReturnList(@Nonnull List<String> list, @Nonnull String string) {
        if (string.length() == 0) {
            return list;
        }
        String input = string.toLowerCase(Locale.ROOT);
        LinkedList<String> returnList = new LinkedList<String>();
        for (String item : list) {
            if (item.toLowerCase(Locale.ROOT).contains(input)) {
                returnList.add(item);
                if (returnList.size() < 80) continue;
                break;
            }
            if (!item.equalsIgnoreCase(input)) continue;
            return Collections.emptyList();
        }
        return returnList;
    }

    @Nonnull
    private List<String> getSlimefunItems() {
        List<SlimefunItem> items = SlimefunPlugin.getRegistry().getEnabledSlimefunItems();
        ArrayList<String> list = new ArrayList<String>(items.size());
        for (SlimefunItem item : items) {
            list.add(item.getID());
        }
        return list;
    }
}

