/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.researching;

import io.github.thebusybiscuit.slimefun4.api.events.ResearchUnlockEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.FireworkUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class Research
implements Keyed {
    private static final int[] RESEARCH_PROGRESS = new int[]{23, 44, 57, 92};
    private static final String PLACEHOLDER_RESEARCH = "%research%";
    private final NamespacedKey key;
    private final int id;
    private final String name;
    private boolean enabled = true;
    private int cost;
    private final List<SlimefunItem> items = new LinkedList<SlimefunItem>();

    public Research(NamespacedKey key, int id, String name, int defaultCost) {
        this.key = key;
        this.id = id;
        this.name = name;
        this.cost = defaultCost;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isEnabled() {
        return SlimefunPlugin.getRegistry().isResearchingEnabled() && this.enabled;
    }

    @Deprecated
    public int getID() {
        return this.id;
    }

    public String getName(Player p) {
        String localized = SlimefunPlugin.getLocalization().getResearchName(p, this.key);
        return localized != null ? localized : this.name;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        if (cost < 0) {
            throw new IllegalArgumentException("Research cost must be zero or greater!");
        }
        this.cost = cost;
    }

    public void addItems(SlimefunItem ... items) {
        for (SlimefunItem item : items) {
            if (item == null) continue;
            item.setResearch(this);
        }
    }

    public Research addItems(ItemStack ... items) {
        for (ItemStack item : items) {
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            if (sfItem == null) continue;
            sfItem.setResearch(this);
        }
        return this;
    }

    public List<SlimefunItem> getAffectedItems() {
        return this.items;
    }

    public boolean canUnlock(Player p) {
        if (!this.isEnabled()) {
            return true;
        }
        boolean creativeResearch = p.getGameMode() == GameMode.CREATIVE && SlimefunPlugin.getRegistry().isFreeCreativeResearchingEnabled();
        return creativeResearch || p.getLevel() >= this.cost;
    }

    public void unlock(Player p, boolean instant) {
        this.unlock(p, instant, pl -> {});
    }

    public void unlock(Player p, boolean instant, Consumer<Player> callback) {
        if (!instant) {
            Slimefun.runSync(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace(PLACEHOLDER_RESEARCH, this.getName(p)).replace("%progress%", "0%"));
            }, 10L);
        }
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            if (!profile.hasUnlocked(this)) {
                Slimefun.runSync(() -> {
                    ResearchUnlockEvent event = new ResearchUnlockEvent(p, this);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        if (instant) {
                            this.finishResearch(p, (PlayerProfile)profile, callback);
                        } else if (SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().add(p.getUniqueId())) {
                            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.research.start", true, msg -> msg.replace(PLACEHOLDER_RESEARCH, this.getName(p)));
                            this.playResearchAnimation(p);
                            Slimefun.runSync(() -> {
                                this.finishResearch(p, (PlayerProfile)profile, callback);
                                SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().remove(p.getUniqueId());
                            }, (long)(RESEARCH_PROGRESS.length + 1) * 20L);
                        }
                    }
                });
            }
        });
    }

    private void finishResearch(Player p, PlayerProfile profile, Consumer<Player> callback) {
        profile.setResearched(this, true);
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.unlocked", true, msg -> msg.replace(PLACEHOLDER_RESEARCH, this.getName(p)));
        callback.accept(p);
        if (SlimefunPlugin.getRegistry().isResearchFireworkEnabled() && SlimefunGuideSettings.hasFireworksEnabled(p)) {
            FireworkUtils.launchRandom((Entity)p, 1);
        }
    }

    private void playResearchAnimation(Player p) {
        for (int i = 1; i < RESEARCH_PROGRESS.length + 1; ++i) {
            int j = i;
            Slimefun.runSync(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace(PLACEHOLDER_RESEARCH, this.getName(p)).replace("%progress%", RESEARCH_PROGRESS[j - 1] + "%"));
            }, (long)i * 20L);
        }
    }

    public void register() {
        SlimefunPlugin.getResearchCfg().setDefaultValue("enable-researching", true);
        String path = this.key.getNamespace() + '.' + this.key.getKey();
        if (SlimefunPlugin.getResearchCfg().contains(path + ".enabled") && !SlimefunPlugin.getResearchCfg().getBoolean(path + ".enabled")) {
            for (SlimefunItem item : new ArrayList<SlimefunItem>(this.items)) {
                if (item == null) continue;
                item.setResearch(null);
            }
            this.enabled = false;
            return;
        }
        SlimefunPlugin.getResearchCfg().setDefaultValue(path + ".cost", this.getCost());
        SlimefunPlugin.getResearchCfg().setDefaultValue(path + ".enabled", true);
        this.setCost(SlimefunPlugin.getResearchCfg().getInt(path + ".cost"));
        this.enabled = true;
        SlimefunPlugin.getRegistry().getResearches().add(this);
    }

    public static Optional<Research> getResearch(NamespacedKey key) {
        if (key == null) {
            return Optional.empty();
        }
        for (Research research : SlimefunPlugin.getRegistry().getResearches()) {
            if (!research.getKey().equals((Object)key)) continue;
            return Optional.of(research);
        }
        return Optional.empty();
    }

    public String toString() {
        return "Research (" + this.getKey() + ')';
    }
}

