/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import io.github.thebusybiscuit.slimefun4.core.attributes.ItemAttribute;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;

public interface EnergyNetComponent
extends ItemAttribute {
    public EnergyNetComponentType getEnergyComponentType();

    public int getCapacity();

    default public boolean isChargeable() {
        return this.getCapacity() > 0;
    }

    default public int getCharge(Location l) {
        Validate.notNull((Object)l, (String)"Location was null!");
        String charge = BlockStorage.getLocationInfo(l, "energy-charge");
        if (charge != null) {
            return Integer.parseInt(charge);
        }
        return 0;
    }

    default public void setCharge(Location l, int charge) {
        Validate.notNull((Object)l, (String)"Location was null!");
        Validate.isTrue((charge >= 0 ? 1 : 0) != 0, (String)"You can only set a charge of zero or more!");
        int capacity = this.getCapacity();
        if (capacity > 0 && (charge = NumberUtils.clamp(0, charge, capacity)) != this.getCharge(l)) {
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(charge), false);
            if (this.getEnergyComponentType() == EnergyNetComponentType.CAPACITOR) {
                SlimefunUtils.updateCapacitorTexture(l, charge, capacity);
            }
        }
    }

    default public void addCharge(Location l, int charge) {
        int currentCharge;
        Validate.notNull((Object)l, (String)"Location was null!");
        Validate.isTrue((charge > 0 ? 1 : 0) != 0, (String)"You can only add a positive charge!");
        int capacity = this.getCapacity();
        if (capacity > 0 && (currentCharge = this.getCharge(l)) < capacity) {
            int newCharge = Math.min(capacity, currentCharge + charge);
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(newCharge), false);
            if (this.getEnergyComponentType() == EnergyNetComponentType.CAPACITOR) {
                SlimefunUtils.updateCapacitorTexture(l, charge, capacity);
            }
        }
    }

    default public void removeCharge(Location l, int charge) {
        int currentCharge;
        Validate.notNull((Object)l, (String)"Location was null!");
        Validate.isTrue((charge > 0 ? 1 : 0) != 0, (String)"The charge to remove must be greater than zero!");
        int capacity = this.getCapacity();
        if (capacity > 0 && (currentCharge = this.getCharge(l)) > 0) {
            int newCharge = Math.max(0, currentCharge - charge);
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(newCharge), false);
            if (this.getEnergyComponentType() == EnergyNetComponentType.CAPACITOR) {
                SlimefunUtils.updateCapacitorTexture(l, charge, capacity);
            }
        }
    }
}

