/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.resources;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

abstract class SlimefunResource
implements GEOResource {
    private final NamespacedKey key;
    private final String defaultName;
    private final ItemStack item;
    private final int maxDeviation;
    private final boolean geoMiner;

    SlimefunResource(String key, String defaultName, ItemStack item, int maxDeviation, boolean geoMiner) {
        Validate.notNull((Object)key, (String)"NamespacedKey cannot be null!");
        Validate.notNull((Object)defaultName, (String)"The default name cannot be null!");
        Validate.notNull((Object)item, (String)"item cannot be null!");
        this.key = new NamespacedKey((Plugin)SlimefunPlugin.instance(), key);
        this.defaultName = defaultName;
        this.item = item;
        this.maxDeviation = maxDeviation;
        this.geoMiner = geoMiner;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.defaultName;
    }

    @Override
    public ItemStack getItem() {
        return this.item.clone();
    }

    @Override
    public int getMaxDeviation() {
        return this.maxDeviation;
    }

    @Override
    public boolean isObtainableFromGEOMiner() {
        return this.geoMiner;
    }
}

