/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.energy;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class EnergyNet
extends Network {
    private static final int RANGE = 6;
    private final Map<Location, EnergyNetProvider> generators = new HashMap<Location, EnergyNetProvider>();
    private final Map<Location, EnergyNetComponent> capacitors = new HashMap<Location, EnergyNetComponent>();
    private final Map<Location, EnergyNetComponent> consumers = new HashMap<Location, EnergyNetComponent>();

    protected EnergyNet(Location l) {
        super(SlimefunPlugin.getNetworkManager(), l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        if (this.regulator.equals((Object)l)) {
            return NetworkComponent.REGULATOR;
        }
        EnergyNetComponent component = EnergyNet.getComponent(l);
        if (component == null) {
            return null;
        }
        switch (component.getEnergyComponentType()) {
            case CAPACITOR: {
                return NetworkComponent.CONNECTOR;
            }
            case CONSUMER: 
            case GENERATOR: {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        EnergyNetComponent component;
        if (from == NetworkComponent.TERMINUS) {
            this.generators.remove(l);
            this.consumers.remove(l);
        }
        if ((component = EnergyNet.getComponent(l)) != null) {
            switch (component.getEnergyComponentType()) {
                case CAPACITOR: {
                    this.capacitors.put(l, component);
                    break;
                }
                case CONSUMER: {
                    this.consumers.put(l, component);
                    break;
                }
                case GENERATOR: {
                    if (component instanceof EnergyNetProvider) {
                        this.generators.put(l, (EnergyNetProvider)component);
                        break;
                    }
                    if (!(component instanceof SlimefunItem)) break;
                    ((SlimefunItem)((Object)component)).warn("This Item is marked as a GENERATOR but does not implement the interface EnergyNetProvider!");
                    break;
                }
            }
        }
    }

    public void tick(Block b) {
        AtomicLong timestamp = new AtomicLong(SlimefunPlugin.getProfiler().newEntry());
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Energy Regulators connected");
            SlimefunPlugin.getProfiler().closeEntry(b.getLocation(), SlimefunItems.ENERGY_REGULATOR.getItem(), timestamp.get());
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&4No Energy Network found");
        } else {
            int supply;
            int remainingEnergy = supply = this.tickAllGenerators(timestamp::getAndAdd) + this.tickAllCapacitors();
            int demand = 0;
            for (Map.Entry<Location, EnergyNetComponent> entry : this.consumers.entrySet()) {
                Location loc = entry.getKey();
                EnergyNetComponent component = entry.getValue();
                int capacity = component.getCapacity();
                int charge = component.getCharge(loc);
                if (charge >= capacity) continue;
                int availableSpace = capacity - charge;
                demand += availableSpace;
                if (remainingEnergy <= 0) continue;
                if (remainingEnergy > availableSpace) {
                    component.setCharge(loc, capacity);
                    remainingEnergy -= availableSpace;
                    continue;
                }
                component.setCharge(loc, charge + remainingEnergy);
                remainingEnergy = 0;
            }
            this.storeRemainingEnergy(remainingEnergy);
            this.updateHologram(b, supply, demand);
        }
        SlimefunPlugin.getProfiler().closeEntry(b.getLocation(), SlimefunItems.ENERGY_REGULATOR.getItem(), timestamp.get());
    }

    private void storeRemainingEnergy(int remainingEnergy) {
        int capacity;
        EnergyNetComponent component;
        Location loc;
        for (Map.Entry<Location, EnergyNetComponent> entry : this.capacitors.entrySet()) {
            loc = entry.getKey();
            component = entry.getValue();
            if (remainingEnergy > 0) {
                capacity = component.getCapacity();
                if (remainingEnergy > capacity) {
                    component.setCharge(loc, capacity);
                    remainingEnergy -= capacity;
                    continue;
                }
                component.setCharge(loc, remainingEnergy);
                remainingEnergy = 0;
                continue;
            }
            component.setCharge(loc, 0);
        }
        for (Map.Entry<Location, EnergyNetComponent> entry : this.generators.entrySet()) {
            loc = entry.getKey();
            component = (EnergyNetProvider)entry.getValue();
            capacity = component.getCapacity();
            if (remainingEnergy > 0) {
                if (remainingEnergy > capacity) {
                    component.setCharge(loc, capacity);
                    remainingEnergy -= capacity;
                    continue;
                }
                component.setCharge(loc, remainingEnergy);
                remainingEnergy = 0;
                continue;
            }
            component.setCharge(loc, 0);
        }
    }

    private int tickAllGenerators(LongConsumer timings) {
        HashSet<Location> explodedBlocks = new HashSet<Location>();
        int supply = 0;
        for (Map.Entry<Location, EnergyNetProvider> entry : this.generators.entrySet()) {
            long timestamp = SlimefunPlugin.getProfiler().newEntry();
            Location loc = entry.getKey();
            EnergyNetProvider provider = entry.getValue();
            SlimefunItem item = (SlimefunItem)((Object)provider);
            try {
                Config config = BlockStorage.getLocationInfo(loc);
                int energy = provider.getGeneratedOutput(loc, config);
                if (provider.isChargeable()) {
                    energy += provider.getCharge(loc);
                }
                if (provider.willExplode(loc, config)) {
                    explodedBlocks.add(loc);
                    BlockStorage.clearBlockInfo(loc);
                    Slimefun.runSync(() -> {
                        loc.getBlock().setType(Material.LAVA);
                        loc.getWorld().createExplosion(loc, 0.0f, false);
                    });
                } else {
                    supply += energy;
                }
            }
            catch (Exception | LinkageError t) {
                explodedBlocks.add(loc);
                new ErrorReport<Throwable>(t, loc, item);
            }
            long time = SlimefunPlugin.getProfiler().closeEntry(loc, item, timestamp);
            timings.accept(time);
        }
        this.generators.keySet().removeAll(explodedBlocks);
        return supply;
    }

    private int tickAllCapacitors() {
        int supply = 0;
        for (Map.Entry<Location, EnergyNetComponent> entry : this.capacitors.entrySet()) {
            supply += entry.getValue().getCharge(entry.getKey());
        }
        return supply;
    }

    private void updateHologram(Block b, double supply, double demand) {
        if (demand > supply) {
            String netLoss = DoubleHandler.getFancyDouble(Math.abs(supply - demand));
            SimpleHologram.update(b, "&4&l- &c" + netLoss + " &7J &e\u26a1");
        } else {
            String netGain = DoubleHandler.getFancyDouble(supply - demand);
            SimpleHologram.update(b, "&2&l+ &a" + netGain + " &7J &e\u26a1");
        }
    }

    private static EnergyNetComponent getComponent(Location l) {
        SlimefunItem item = BlockStorage.check(l);
        if (item instanceof EnergyNetComponent) {
            return (EnergyNetComponent)((Object)item);
        }
        return null;
    }

    public static EnergyNet getNetworkFromLocationOrCreate(Location l) {
        Optional<EnergyNet> energyNetwork = SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, EnergyNet.class);
        if (energyNetwork.isPresent()) {
            return energyNetwork.get();
        }
        EnergyNet network = new EnergyNet(l);
        SlimefunPlugin.getNetworkManager().registerNetwork(network);
        return network;
    }
}

