/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.PersistentDataService;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SlimefunLocalization;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends SlimefunLocalization
implements PersistentDataService {
    private static final String LANGUAGE_PATH = "language";
    private final Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private final boolean translationsEnabled;
    private final SlimefunPlugin plugin;
    private final String prefix;
    private final NamespacedKey languageKey;
    private final Language defaultLanguage;

    public LocalizationService(SlimefunPlugin plugin, String prefix, String serverDefaultLanguage) {
        super(plugin);
        this.plugin = plugin;
        this.prefix = prefix;
        this.languageKey = new NamespacedKey((Plugin)plugin, LANGUAGE_PATH);
        if (serverDefaultLanguage != null) {
            this.translationsEnabled = SlimefunPlugin.getCfg().getBoolean("options.enable-translations");
            this.defaultLanguage = new Language(serverDefaultLanguage, "11b3188fd44902f72602bd7c2141f5a70673a411adb3d81862c69e536166b");
            this.defaultLanguage.setMessagesFile(this.getConfig().getConfiguration());
            this.loadEmbeddedLanguages();
            String language = this.getConfig().getString(LANGUAGE_PATH);
            if (language == null) {
                language = serverDefaultLanguage;
            }
            if (this.hasLanguage(serverDefaultLanguage)) {
                this.setLanguage(serverDefaultLanguage, !serverDefaultLanguage.equals(language));
            } else {
                this.setLanguage("en", false);
                plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", serverDefaultLanguage);
            }
            Slimefun.getLogger().log(Level.INFO, "Available languages: {0}", String.join((CharSequence)", ", this.languages.keySet()));
            this.save();
        } else {
            this.translationsEnabled = false;
            this.defaultLanguage = null;
        }
    }

    public boolean isEnabled() {
        return this.translationsEnabled;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public NamespacedKey getKey() {
        return this.languageKey;
    }

    @Override
    public Language getLanguage(String id) {
        return this.languages.get(id);
    }

    @Override
    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    @Override
    public boolean hasLanguage(String language) {
        return this.containsResource("messages_" + language);
    }

    public boolean isLanguageLoaded(String id) {
        Validate.notNull((Object)id, (String)"The language id cannot be null!");
        return this.languages.containsKey(id);
    }

    private boolean containsResource(String file) {
        return this.plugin.getClass().getResource("/languages/" + file + ".yml") != null;
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public Language getLanguage(Player p) {
        Language lang;
        Optional language = this.getString(p, this.languageKey);
        if (language.isPresent() && (lang = this.languages.get(language.get())) != null) {
            return lang;
        }
        return this.getDefaultLanguage();
    }

    private void setLanguage(String language, boolean reset) {
        if (reset) {
            this.getConfig().clear();
        }
        this.defaultLanguage.setResearchesFile(this.streamConfigFile("researches_" + language + ".yml", null));
        this.defaultLanguage.setResourcesFile(this.streamConfigFile("resources_" + language + ".yml", null));
        this.defaultLanguage.setCategoriesFile(this.streamConfigFile("categories_" + language + ".yml", null));
        this.defaultLanguage.setRecipeTypesFile(this.streamConfigFile("recipes_" + language + ".yml", null));
        Slimefun.getLogger().log(Level.INFO, "Loaded language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        String path = "/languages/messages_" + language + ".yml";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.plugin.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, e, () -> "Failed to load language file: \"" + path + "\"");
        }
        this.save();
    }

    @Override
    protected void addLanguage(String id, String texture) {
        Validate.notNull((Object)id, (String)"The language id cannot be null!");
        Validate.notNull((Object)texture, (String)"The language texture cannot be null");
        if (this.hasLanguage(id)) {
            FileConfiguration messages = this.streamConfigFile("messages_" + id + ".yml", this.getConfig().getConfiguration());
            FileConfiguration researches = this.streamConfigFile("researches_" + id + ".yml", null);
            FileConfiguration resources = this.streamConfigFile("resources_" + id + ".yml", null);
            FileConfiguration categories = this.streamConfigFile("categories_" + id + ".yml", null);
            FileConfiguration recipes = this.streamConfigFile("recipes_" + id + ".yml", null);
            Language language = new Language(id, texture);
            language.setMessagesFile(messages);
            language.setResearchesFile(researches);
            language.setResourcesFile(resources);
            language.setCategoriesFile(categories);
            language.setRecipeTypesFile(recipes);
            this.languages.put(id, language);
        }
    }

    public double calculateProgress(Language lang) {
        Validate.notNull((Object)lang, (String)"Cannot get the language progress of null");
        Set<String> defaultKeys = this.getTotalKeys(this.languages.get("en"));
        if (defaultKeys.isEmpty()) {
            return 0.0;
        }
        Set<String> keys = this.getTotalKeys(lang);
        int matches = 0;
        for (String key : defaultKeys) {
            if (!keys.contains(key)) continue;
            ++matches;
        }
        return Math.min(DoubleHandler.fixDouble(100.0 * ((double)matches / (double)defaultKeys.size())), 100.0);
    }

    private Set<String> getTotalKeys(Language lang) {
        return this.getKeys(lang.getFiles());
    }

    private Set<String> getKeys(FileConfiguration ... files) {
        HashSet<String> keys = new HashSet<String>();
        for (FileConfiguration cfg : files) {
            keys.addAll(cfg.getKeys(true));
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileConfiguration streamConfigFile(String file, FileConfiguration defaults) {
        String path = "/languages/" + file;
        if (this.plugin.getClass().getResourceAsStream(path) == null) {
            return new YamlConfiguration();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.plugin.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            if (defaults != null) {
                config.setDefaults((Configuration)defaults);
            }
            YamlConfiguration yamlConfiguration = config;
            return yamlConfiguration;
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.SEVERE, e, () -> "Failed to load language file into memory: \"" + path + "\"");
            return null;
        }
    }
}

