/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.core.attributes.PiglinBarterDrop;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PiglinListener
implements Listener {
    public PiglinListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        ItemStack item;
        if (e.getEntityType() == EntityType.PIGLIN && SlimefunItem.getByItem(item = e.getItem().getItemStack()) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEntityEvent e) {
        SlimefunItem sfItem;
        if (!e.getRightClicked().isValid() || e.getRightClicked().getType() != EntityType.PIGLIN) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = e.getHand() == EquipmentSlot.OFF_HAND ? p.getInventory().getItemInOffHand() : p.getInventory().getItemInMainHand();
        if (item.getType() == Material.GOLD_INGOT && (sfItem = SlimefunItem.getByItem(item)) != null) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.piglin-barter", true);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPiglinDropItem(EntityDropItemEvent e) {
        if (e.getEntity() instanceof Piglin) {
            Set<ItemStack> drops = SlimefunPlugin.getRegistry().getBarteringDrops();
            for (ItemStack is : drops) {
                SlimefunItem sfi = SlimefunItem.getByItem(is);
                if (!(sfi instanceof PiglinBarterDrop)) continue;
                int chance = ((PiglinBarterDrop)((Object)sfi)).getBarteringLootChance();
                if (chance < 1 || chance >= 100) {
                    sfi.warn("The Piglin Bartering chance must be between 1-99%");
                    continue;
                }
                if (chance <= ThreadLocalRandom.current().nextInt(100)) continue;
                e.getItemDrop().setItemStack(sfi.getRecipeOutput());
                return;
            }
        }
    }
}

