/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class ChargingBench
extends AContainer {
    public ChargingBench(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_PICKAXE);
    }

    @Override
    public int getEnergyConsumption() {
        return 10;
    }

    @Override
    public int getCapacity() {
        return 128;
    }

    @Override
    protected void tick(Block b) {
        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
            return;
        }
        BlockMenu inv = BlockStorage.getInventory(b);
        for (int slot : this.getInputSlots()) {
            ItemStack item = inv.getItemInSlot(slot);
            if (!this.charge(b, inv, slot, item)) continue;
            return;
        }
    }

    private boolean charge(Block b, BlockMenu inv, int slot, ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem instanceof Rechargeable) {
            float charge = (float)this.getEnergyConsumption() / 2.0f;
            if (((Rechargeable)((Object)sfItem)).addItemCharge(item, charge)) {
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
            } else if (inv.fits(item, this.getOutputSlots())) {
                inv.pushItem(item, this.getOutputSlots());
                inv.replaceExistingItem(slot, null);
            }
            return true;
        }
        if (sfItem != null && inv.fits(item, this.getOutputSlots())) {
            inv.pushItem(item, this.getOutputSlots());
            inv.replaceExistingItem(slot, null);
        }
        return false;
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "CHARGING_BENCH";
    }
}

