/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.food;

import io.github.thebusybiscuit.slimefun4.core.handlers.ItemConsumptionHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Juice
extends SimpleSlimefunItem<ItemConsumptionHandler> {
    private final List<PotionEffect> effects;

    public Juice(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        this(category, item, recipeType, recipe, null);
    }

    public Juice(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        super(category, item, recipeType, recipe, recipeOutput);
        ItemMeta meta = item.getItemMeta();
        this.effects = meta instanceof PotionMeta ? ((PotionMeta)meta).getCustomEffects() : new ArrayList<PotionEffect>();
    }

    @Override
    public ItemConsumptionHandler getItemHandler() {
        return (e, p, item) -> {
            for (PotionEffect effect : this.effects) {
                if (!effect.getType().equals((Object)PotionEffectType.SATURATION)) continue;
                p.addPotionEffect(effect);
                break;
            }
            this.removeGlassBottle(p, item);
        };
    }

    private void removeGlassBottle(Player p, ItemStack item) {
        if (SlimefunUtils.isItemSimilar(item, p.getInventory().getItemInMainHand(), true)) {
            if (p.getInventory().getItemInMainHand().getAmount() == 1) {
                Slimefun.runSync(() -> p.getEquipment().getItemInMainHand().setAmount(0));
            } else {
                Slimefun.runSync(() -> p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, 1)}));
            }
        } else if (SlimefunUtils.isItemSimilar(item, p.getInventory().getItemInOffHand(), true)) {
            if (p.getInventory().getItemInOffHand().getAmount() == 1) {
                Slimefun.runSync(() -> p.getEquipment().getItemInOffHand().setAmount(0));
            } else {
                Slimefun.runSync(() -> p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, 1)}));
            }
        }
    }
}

