/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.mrCookieSlime.EmeraldEnchants.EmeraldEnchants;
import me.mrCookieSlime.EmeraldEnchants.ItemEnchantment;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;

public class AutoEnchanter
extends AContainer {
    private final int emeraldEnchantsLimit = SlimefunPlugin.getCfg().getInt("options.emerald-enchantment-limit");

    public AutoEnchanter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.GOLDEN_CHESTPLATE);
    }

    @Override
    public int getEnergyConsumption() {
        return 9;
    }

    @Override
    public int getCapacity() {
        return 128;
    }

    @Override
    protected void tick(Block b) {
        BlockMenu menu = BlockStorage.getInventory(b.getLocation());
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(menu, 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                    return;
                }
                ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                progress.put(b, timeleft - 1);
            } else {
                menu.replaceExistingItem(22, new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ", new String[0]));
                for (ItemStack item : ((MachineRecipe)processing.get(b)).getOutput()) {
                    menu.pushItem(item, this.getOutputSlots());
                }
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe recipe = this.findRecipe(menu);
            if (recipe != null) {
                if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                    return;
                }
                for (int slot : this.getInputSlots()) {
                    menu.consumeItem(slot);
                }
                processing.put(b, recipe);
                progress.put(b, recipe.getTicks());
            }
        }
    }

    private MachineRecipe findRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            if (!this.isEnchantable(target)) {
                return null;
            }
            ItemStack item = menu.getItemInSlot(slot);
            if (item == null || item.getType() != Material.ENCHANTED_BOOK || target == null) continue;
            HashMap enchantments = new HashMap();
            HashSet<ItemEnchantment> emeraldEnchantments = new HashSet<ItemEnchantment>();
            int amount = 0;
            int specialAmount = 0;
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
            for (Map.Entry e : meta.getStoredEnchants().entrySet()) {
                if (!((Enchantment)e.getKey()).canEnchantItem(target)) continue;
                ++amount;
                enchantments.put(e.getKey(), e.getValue());
            }
            if (SlimefunPlugin.getThirdPartySupportService().isEmeraldEnchantsInstalled()) {
                for (ItemEnchantment enchantment : EmeraldEnchants.getInstance().getRegistry().getEnchantments(item)) {
                    if (!EmeraldEnchants.getInstance().getRegistry().isApplicable(target, enchantment.getEnchantment()) || EmeraldEnchants.getInstance().getRegistry().getEnchantmentLevel(target, enchantment.getEnchantment().getName()) >= enchantment.getLevel()) continue;
                    ++amount;
                    ++specialAmount;
                    emeraldEnchantments.add(enchantment);
                }
                specialAmount += EmeraldEnchants.getInstance().getRegistry().getEnchantments(target).size();
            }
            if (amount > 0 && specialAmount <= this.emeraldEnchantsLimit) {
                ItemStack enchantedItem = target.clone();
                enchantedItem.setAmount(1);
                for (Map.Entry entry : enchantments.entrySet()) {
                    enchantedItem.addUnsafeEnchantment((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
                for (ItemEnchantment ench : emeraldEnchantments) {
                    EmeraldEnchants.getInstance().getRegistry().applyEnchantment(enchantedItem, ench.getEnchantment(), ench.getLevel());
                }
                return new MachineRecipe(75 * amount, new ItemStack[]{target, item}, new ItemStack[]{enchantedItem, new ItemStack(Material.BOOK)});
            }
            return null;
        }
        return null;
    }

    private boolean isEnchantable(ItemStack item) {
        SlimefunItem sfItem = null;
        if (item != null && item.getType() != Material.ENCHANTED_BOOK) {
            sfItem = SlimefunItem.getByItem(item);
        }
        return sfItem == null || sfItem.isEnchantable();
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_ENCHANTER";
    }
}

