/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.energy;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class EnergyNet
extends Network {
    private static final int RANGE = 6;
    private final Set<Location> generators = new HashSet<Location>();
    private final Set<Location> storage = new HashSet<Location>();
    private final Set<Location> consumers = new HashSet<Location>();

    public static EnergyNetComponentType getComponent(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return EnergyNetComponentType.NONE;
        }
        SlimefunItem item = SlimefunItem.getByID(id);
        if (item instanceof EnergyNetComponent) {
            return ((EnergyNetComponent)((Object)item)).getEnergyComponentType();
        }
        return EnergyNetComponentType.NONE;
    }

    public static EnergyNet getNetworkFromLocationOrCreate(Location l) {
        Optional<EnergyNet> cargoNetwork = SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, EnergyNet.class);
        if (cargoNetwork.isPresent()) {
            return cargoNetwork.get();
        }
        EnergyNet network = new EnergyNet(l);
        SlimefunPlugin.getNetworkManager().registerNetwork(network);
        return network;
    }

    protected EnergyNet(Location l) {
        super(SlimefunPlugin.getNetworkManager(), l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        if (this.regulator.equals((Object)l)) {
            return NetworkComponent.REGULATOR;
        }
        switch (EnergyNet.getComponent(l)) {
            case CAPACITOR: {
                return NetworkComponent.CONNECTOR;
            }
            case CONSUMER: 
            case GENERATOR: {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.generators.remove(l);
            this.consumers.remove(l);
        }
        switch (EnergyNet.getComponent(l)) {
            case CAPACITOR: {
                this.storage.add(l);
                break;
            }
            case CONSUMER: {
                this.consumers.add(l);
                break;
            }
            case GENERATOR: {
                this.generators.add(l);
                break;
            }
        }
    }

    public void tick(Block b) {
        AtomicLong timestamp = new AtomicLong(SlimefunPlugin.getProfiler().newEntry());
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Energy Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&4No Energy Network found");
        } else {
            int supply;
            HashMap<Location, Integer> generatorsWithCapacity = new HashMap<Location, Integer>();
            int remainingEnergy = supply = this.tickAllGenerators(generatorsWithCapacity, timestamp::getAndAdd) + this.tickAllCapacitors();
            int demand = 0;
            for (Location machine : this.consumers) {
                int capacity = ChargableBlock.getMaxCharge(machine);
                int charge = ChargableBlock.getCharge(machine);
                if (charge >= capacity) continue;
                int availableSpace = capacity - charge;
                demand += availableSpace;
                if (remainingEnergy <= 0) continue;
                if (remainingEnergy > availableSpace) {
                    ChargableBlock.setUnsafeCharge(machine, capacity, false);
                    remainingEnergy -= availableSpace;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(machine, charge + remainingEnergy, false);
                remainingEnergy = 0;
            }
            this.storeExcessEnergy(generatorsWithCapacity, remainingEnergy);
            this.updateHologram(b, supply, demand);
        }
        SlimefunPlugin.getProfiler().closeEntry(b.getLocation(), SlimefunItems.ENERGY_REGULATOR.getItem(), timestamp.get());
    }

    private void storeExcessEnergy(Map<Location, Integer> generators, int available) {
        for (Location location : this.storage) {
            if (available > 0) {
                int capacity = ChargableBlock.getMaxCharge(location);
                if (available > capacity) {
                    ChargableBlock.setUnsafeCharge(location, capacity, true);
                    available -= capacity;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(location, available, true);
                available = 0;
                continue;
            }
            ChargableBlock.setUnsafeCharge(location, 0, true);
        }
        for (Map.Entry entry : generators.entrySet()) {
            Location generator = (Location)entry.getKey();
            int capacity = (Integer)entry.getValue();
            if (available > 0) {
                if (available > capacity) {
                    ChargableBlock.setUnsafeCharge(generator, capacity, false);
                    available -= capacity;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(generator, available, false);
                available = 0;
                continue;
            }
            ChargableBlock.setUnsafeCharge(generator, 0, false);
        }
    }

    private int tickAllGenerators(Map<Location, Integer> generatorsWithCapacity, LongConsumer timeCallback) {
        HashSet<Location> exploded = new HashSet<Location>();
        int supply = 0;
        for (Location source : this.generators) {
            long timestamp = SlimefunPlugin.getProfiler().newEntry();
            Config config = BlockStorage.getLocationInfo(source);
            SlimefunItem item = SlimefunItem.getByID(config.getString("id"));
            if (item instanceof EnergyNetProvider) {
                try {
                    EnergyNetProvider provider = (EnergyNetProvider)((Object)item);
                    int energy = provider.getGeneratedOutput(source, config);
                    if (provider.getCapacity() > 0) {
                        generatorsWithCapacity.put(source, provider.getCapacity());
                        String charge = config.getString("energy-charge");
                        if (charge != null) {
                            energy += Integer.parseInt(charge);
                        }
                    }
                    if (provider.willExplode(source, config)) {
                        exploded.add(source);
                        BlockStorage.clearBlockInfo(source);
                        Slimefun.runSync(() -> {
                            source.getBlock().setType(Material.LAVA);
                            source.getWorld().createExplosion(source, 0.0f, false);
                        });
                    } else {
                        supply += energy;
                    }
                }
                catch (Exception | LinkageError t) {
                    exploded.add(source);
                    new ErrorReport<Throwable>(t, source, item);
                }
                long time = SlimefunPlugin.getProfiler().closeEntry(source, item, timestamp);
                timeCallback.accept(time);
                continue;
            }
            exploded.add(source);
        }
        this.generators.removeAll(exploded);
        return supply;
    }

    private int tickAllCapacitors() {
        int supply = 0;
        for (Location capacitor : this.storage) {
            supply += ChargableBlock.getCharge(capacitor);
        }
        return supply;
    }

    private void updateHologram(Block b, double supply, double demand) {
        if (demand > supply) {
            String netLoss = DoubleHandler.getFancyDouble(Math.abs(supply - demand));
            SimpleHologram.update(b, "&4&l- &c" + netLoss + " &7J &e\u26a1");
        } else {
            String netGain = DoubleHandler.getFancyDouble(supply - demand);
            SimpleHologram.update(b, "&2&l+ &a" + netGain + " &7J &e\u26a1");
        }
    }
}

