/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import java.util.EnumMap;
import java.util.Map;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public abstract class AutoBrewer
extends AContainer {
    private static final Map<Material, PotionType> potionRecipes = new EnumMap<Material, PotionType>(Material.class);
    private static final Map<PotionType, PotionType> fermentations = new EnumMap<PotionType, PotionType>(PotionType.class);

    public AutoBrewer(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        ItemStack input1 = menu.getItemInSlot(this.getInputSlots()[0]);
        ItemStack input2 = menu.getItemInSlot(this.getInputSlots()[1]);
        if (input1 == null || input2 == null) {
            return null;
        }
        if (this.isPotion(input1.getType()) || this.isPotion(input2.getType())) {
            ItemStack ingredient;
            boolean isPotionInFirstSlot = this.isPotion(input1.getType());
            ItemStack itemStack = ingredient = isPotionInFirstSlot ? input2 : input1;
            if (ingredient.hasItemMeta()) {
                return null;
            }
            ItemStack potionItem = isPotionInFirstSlot ? input1 : input2;
            PotionMeta potion = (PotionMeta)potionItem.getItemMeta();
            ItemStack output = this.brew(ingredient.getType(), potionItem.getType(), potion);
            if (output == null) {
                return null;
            }
            output.setItemMeta((ItemMeta)potion);
            if (!InvUtils.fits(menu.toInventory(), output, this.getOutputSlots())) {
                return null;
            }
            for (int slot : this.getInputSlots()) {
                menu.consumeItem(slot);
            }
            return new MachineRecipe(30, new ItemStack[]{input1, input2}, new ItemStack[]{output});
        }
        return null;
    }

    private ItemStack brew(Material input, Material potionType, PotionMeta potion) {
        PotionData data = potion.getBasePotionData();
        if (data.getType() == PotionType.WATER) {
            if (input == Material.FERMENTED_SPIDER_EYE) {
                potion.setBasePotionData(new PotionData(PotionType.WEAKNESS, false, false));
                return new ItemStack(potionType);
            }
            if (input == Material.NETHER_WART) {
                potion.setBasePotionData(new PotionData(PotionType.AWKWARD, false, false));
                return new ItemStack(potionType);
            }
            if (potionType == Material.POTION && input == Material.GUNPOWDER) {
                return new ItemStack(Material.SPLASH_POTION);
            }
            if (potionType == Material.SPLASH_POTION && input == Material.DRAGON_BREATH) {
                return new ItemStack(Material.LINGERING_POTION);
            }
            return null;
        }
        if (input == Material.FERMENTED_SPIDER_EYE) {
            potion.setBasePotionData(new PotionData(fermentations.get(data.getType()), false, false));
            return new ItemStack(potionType);
        }
        if (input == Material.REDSTONE) {
            potion.setBasePotionData(new PotionData(data.getType(), true, data.isUpgraded()));
            return new ItemStack(potionType);
        }
        if (input == Material.GLOWSTONE_DUST) {
            potion.setBasePotionData(new PotionData(data.getType(), data.isExtended(), true));
            return new ItemStack(potionType);
        }
        if (data.getType() == PotionType.AWKWARD && potionRecipes.containsKey(input)) {
            potion.setBasePotionData(new PotionData(potionRecipes.get(input), false, false));
            return new ItemStack(potionType);
        }
        return null;
    }

    private boolean isPotion(Material mat) {
        return mat == Material.POTION || mat == Material.SPLASH_POTION || mat == Material.LINGERING_POTION;
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FISHING_ROD);
    }

    @Override
    public int getEnergyConsumption() {
        return 6;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_BREWER";
    }

    @Override
    public int getCapacity() {
        return 128;
    }

    static {
        potionRecipes.put(Material.SUGAR, PotionType.SPEED);
        potionRecipes.put(Material.RABBIT_FOOT, PotionType.JUMP);
        potionRecipes.put(Material.BLAZE_POWDER, PotionType.STRENGTH);
        potionRecipes.put(Material.GLISTERING_MELON_SLICE, PotionType.INSTANT_HEAL);
        potionRecipes.put(Material.SPIDER_EYE, PotionType.POISON);
        potionRecipes.put(Material.GHAST_TEAR, PotionType.REGEN);
        potionRecipes.put(Material.MAGMA_CREAM, PotionType.FIRE_RESISTANCE);
        potionRecipes.put(Material.PUFFERFISH, PotionType.WATER_BREATHING);
        potionRecipes.put(Material.GOLDEN_CARROT, PotionType.NIGHT_VISION);
        potionRecipes.put(Material.TURTLE_HELMET, PotionType.TURTLE_MASTER);
        potionRecipes.put(Material.PHANTOM_MEMBRANE, PotionType.SLOW_FALLING);
        fermentations.put(PotionType.SPEED, PotionType.SLOWNESS);
        fermentations.put(PotionType.JUMP, PotionType.SLOWNESS);
        fermentations.put(PotionType.INSTANT_HEAL, PotionType.INSTANT_DAMAGE);
        fermentations.put(PotionType.POISON, PotionType.INSTANT_DAMAGE);
        fermentations.put(PotionType.NIGHT_VISION, PotionType.INVISIBILITY);
    }
}

