/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class ElectricSmeltery
extends AContainer {
    private static final int[] border = new int[]{4, 5, 6, 7, 8, 13, 31, 40, 41, 42, 43, 44};
    private static final int[] inputBorder = new int[]{0, 1, 2, 3, 9, 12, 18, 21, 27, 30, 36, 37, 38, 39};
    private static final int[] outputBorder = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};

    public ElectricSmeltery(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getID(), this.getInventoryTitle()){

            @Override
            public void init() {
                ElectricSmeltery.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return ElectricSmeltery.this.getOutputSlots();
                }
                int fullSlots = 0;
                LinkedList<Integer> slots = new LinkedList<Integer>();
                for (int slot : ElectricSmeltery.this.getInputSlots()) {
                    ItemStack stack = menu.getItemInSlot(slot);
                    if (stack == null || !SlimefunUtils.isItemSimilar(stack, item, true, false)) continue;
                    if (stack.getAmount() >= stack.getMaxStackSize()) {
                        ++fullSlots;
                    }
                    slots.add(slot);
                }
                if (slots.isEmpty()) {
                    return ElectricSmeltery.this.getInputSlots();
                }
                if (fullSlots == slots.size()) {
                    return new int[0];
                }
                Collections.sort(slots, ElectricSmeltery.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
        ElectricSmeltery.registerBlockHandler(this.getID(), (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                inv.dropItems(b.getLocation(), this.getInputSlots());
                inv.dropItems(b.getLocation(), this.getOutputSlots());
            }
            progress.remove(b);
            processing.remove(b);
            return true;
        });
        this.registerDefaultRecipes();
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return (slot1, slot2) -> menu.getItemInSlot((int)slot1).getAmount() - menu.getItemInSlot((int)slot2).getAmount();
    }

    @Override
    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, new CustomItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : inputBorder) {
            preset.addItem(i, new CustomItem(Material.CYAN_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : outputBorder) {
            preset.addItem(i, new CustomItem(Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
        preset.addItem(22, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    @Override
    public String getInventoryTitle() {
        return "&cElectric Smeltery";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FLINT_AND_STEEL);
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{10, 11, 19, 20, 28, 29};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    @Override
    public String getMachineIdentifier() {
        return "ELECTRIC_SMELTERY";
    }
}

