/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.handlers;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Arrays;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.LoopIterator;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollection;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.GlassPane;

public class RainbowTickHandler
extends BlockTicker {
    private final LoopIterator<Material> iterator;
    private final boolean glassPanes;
    private Material material;

    public RainbowTickHandler(Material ... materials) {
        Validate.noNullElements((Object[])materials, (String)"A RainbowTicker cannot have a Material that is null!");
        if (materials.length == 0) {
            throw new IllegalArgumentException("A RainbowTicker must have at least one Material associated with it!");
        }
        this.glassPanes = this.containsGlassPanes(materials);
        this.iterator = new LoopIterator<Material>(Arrays.asList(materials));
        this.material = this.iterator.next();
    }

    private boolean containsGlassPanes(Material[] materials) {
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return false;
        }
        for (Material type : materials) {
            if (!(type.createBlockData() instanceof GlassPane)) continue;
            return true;
        }
        return false;
    }

    public RainbowTickHandler(MaterialCollection collection) {
        this(collection.getAsArray());
    }

    @Override
    public void tick(Block b, SlimefunItem item, Config data) {
        BlockData blockData;
        if (b.getType() == Material.AIR) {
            return;
        }
        if (this.glassPanes && (blockData = b.getBlockData()) instanceof GlassPane) {
            BlockData block = this.material.createBlockData(bd -> {
                if (bd instanceof GlassPane) {
                    GlassPane previousData = (GlassPane)blockData;
                    GlassPane nextData = (GlassPane)bd;
                    nextData.setWaterlogged(previousData.isWaterlogged());
                    for (BlockFace face : previousData.getAllowedFaces()) {
                        nextData.setFace(face, previousData.hasFace(face));
                    }
                }
            });
            b.setBlockData(block, false);
            return;
        }
        b.setType(this.material, false);
    }

    @Override
    public void uniqueTick() {
        this.material = this.iterator.next();
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }
}

