/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class TeleportationManager {
    private final Set<UUID> teleporterUsers = new HashSet<UUID>();
    private final int[] teleporterBorder = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] teleporterInventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};

    public void openTeleporterGUI(Player p, UUID uuid, Block b, int complexity) {
        if (this.teleporterUsers.contains(p.getUniqueId())) {
            return;
        }
        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.teleporterUsers.add(p.getUniqueId());
        PlayerProfile.fromUUID(uuid, profile -> {
            ChestMenu menu = new ChestMenu("&3Teleporter");
            menu.addMenuCloseHandler(pl -> this.teleporterUsers.remove(pl.getUniqueId()));
            for (int slot : this.teleporterBorder) {
                menu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            menu.addItem(4, (ItemStack)new CustomItem(HeadTexture.GLOBE_OVERWORLD.getAsItemStack(), ChatColor.YELLOW + SlimefunPlugin.getLocalization().getMessage(p, "machines.TELEPORTER.gui.title"), new String[0]));
            menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
            Location source = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + 2.0, (double)b.getZ() + 0.5);
            int index = 0;
            for (Waypoint waypoint : profile.getWaypoints()) {
                if (index >= this.teleporterInventory.length) break;
                int slot = this.teleporterInventory[index];
                Location l = waypoint.getLocation();
                double time = DoubleHandler.fixDouble(0.5 * (double)this.getTeleportationTime(complexity, source, l));
                String[] lore = new String[]{"", "&8\u21e8 &7" + SlimefunPlugin.getLocalization().getResourceString(p, "tooltips.world") + ": &f" + l.getWorld().getName(), "&8\u21e8 &7X: &f" + l.getX(), "&8\u21e8 &7Y: &f" + l.getY(), "&8\u21e8 &7Z: &f" + l.getZ(), "&8\u21e8 &7" + SlimefunPlugin.getLocalization().getMessage(p, "machines.TELEPORTER.gui.time") + ": &f" + time + "s", "", "&8\u21e8 &c" + SlimefunPlugin.getLocalization().getMessage(p, "machines.TELEPORTER.gui.tooltip")};
                menu.addItem(slot, (ItemStack)new CustomItem(waypoint.getIcon(), waypoint.getName().replace("player:death ", ""), lore));
                menu.addMenuClickHandler(slot, (pl, s, item, action) -> {
                    pl.closeInventory();
                    this.teleport(pl.getUniqueId(), complexity, source, l, false);
                    return false;
                });
                ++index;
            }
            Slimefun.runSync(() -> menu.open(new Player[]{p}));
        });
    }

    public void teleport(UUID uuid, int complexity, Location source, Location destination, boolean resistance) {
        this.teleporterUsers.add(uuid);
        int time = this.getTeleportationTime(complexity, source, destination);
        this.updateProgress(uuid, Math.max(1, 100 / time), 0, source, destination, resistance);
    }

    public int getTeleportationTime(int complexity, Location source, Location destination) {
        if (complexity < 100) {
            return 100;
        }
        int speed = 50000 + complexity * complexity;
        return 1 + Math.min(4 * this.distanceSquared(source, destination) / speed, 40);
    }

    private int distanceSquared(Location source, Location destination) {
        if (source.getWorld().getUID().equals(destination.getWorld().getUID())) {
            int distance = (int)source.distanceSquared(destination);
            return Math.min(distance, 100000000);
        }
        return 150000000;
    }

    private boolean isValid(Player p, Location source) {
        return p != null && p.getLocation().distanceSquared(source) < 2.0;
    }

    private void cancel(UUID uuid, Player p) {
        this.teleporterUsers.remove(uuid);
        if (p != null) {
            p.sendTitle(ChatColors.color(SlimefunPlugin.getLocalization().getMessage(p, "machines.TELEPORTER.cancelled")), ChatColors.color("&c&k40&f&c%"), 20, 60, 20);
        }
    }

    private void updateProgress(UUID uuid, int speed, int progress, Location source, Location destination, boolean resistance) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (this.isValid(p, source)) {
            if (progress > 99) {
                p.sendTitle(ChatColors.color(SlimefunPlugin.getLocalization().getMessage(p, "machines.TELEPORTER.teleported")), ChatColors.color("&b100%"), 20, 60, 20);
                PaperLib.teleportAsync((Entity)p, destination).thenAccept(teleported -> {
                    if (teleported.booleanValue()) {
                        Slimefun.runSync(() -> {
                            if (resistance) {
                                p.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 600, 20));
                                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.TELEPORTER.invulnerability");
                            }
                            Location loc = new Location(destination.getWorld(), destination.getX(), destination.getY() + 1.0, destination.getZ());
                            destination.getWorld().spawnParticle(Particle.PORTAL, loc, progress * 2, (double)0.2f, (double)0.8f, (double)0.2f);
                            destination.getWorld().playSound(destination, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
                            this.teleporterUsers.remove(uuid);
                        });
                    }
                });
            } else {
                p.sendTitle(ChatColors.color(SlimefunPlugin.getLocalization().getMessage(p, "machines.TELEPORTER.teleporting")), ChatColors.color("&b" + progress + "%"), 0, 60, 0);
                source.getWorld().spawnParticle(Particle.PORTAL, source, progress * 2, (double)0.2f, (double)0.8f, (double)0.2f);
                source.getWorld().playSound(source, Sound.BLOCK_BEACON_AMBIENT, 1.0f, 0.6f);
                Slimefun.runSync(() -> this.updateProgress(uuid, speed, progress + speed, source, destination, resistance), 10L);
            }
        } else {
            this.cancel(uuid, p);
        }
    }
}

