/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.scheduling;

import java.util.function.IntConsumer;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class TaskQueue {
    private Node head;

    public void execute(@NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (this.head == null) {
            throw new IllegalStateException("Cannot execute TaskQueue, no head was found");
        }
        this.run(plugin, this.head, 0);
    }

    private void run(Plugin plugin, Node node, int index) {
        if (node == null) {
            return;
        }
        Runnable runnable = () -> {
            node.getRunnable().accept(index);
            this.run(plugin, node.getNextNode(), index + 1);
        };
        if (node.isAsynchronously()) {
            if (node.getDelay() > 0) {
                Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, runnable, (long)node.getDelay());
            } else {
                Bukkit.getScheduler().runTaskAsynchronously(plugin, runnable);
            }
        } else if (node.getDelay() > 0) {
            Bukkit.getScheduler().runTaskLater(plugin, runnable, (long)node.getDelay());
        } else {
            Bukkit.getScheduler().runTask(plugin, runnable);
        }
    }

    public TaskQueue thenRun(@NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.append(new Node(consumer, false));
    }

    public TaskQueue thenRun(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRun((int i) -> runnable.run());
    }

    public TaskQueue thenRunAsynchronously(@NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.append(new Node(consumer, true));
    }

    public TaskQueue thenRunAsynchronously(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRunAsynchronously((int i) -> runnable.run());
    }

    public TaskQueue thenRun(int ticks, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ticks < 1) {
            throw new IllegalArgumentException("thenAfter() must be given a time that is greater than zero!");
        }
        return this.append(new Node(consumer, ticks, false));
    }

    public TaskQueue thenRun(int ticks, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRun(ticks, (int i) -> runnable.run());
    }

    public TaskQueue thenRunAsynchronously(int ticks, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ticks < 1) {
            throw new IllegalArgumentException("thenAfter() must be given a time that is greater than zero!");
        }
        return this.append(new Node(consumer, ticks, true));
    }

    public TaskQueue thenRunAsynchronously(int ticks, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRunAsynchronously(ticks, (int i) -> runnable.run());
    }

    public TaskQueue thenRepeat(int iterations, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        for (int i = 0; i < iterations; ++i) {
            this.append(new Node(consumer, false));
        }
        return this;
    }

    public TaskQueue thenRepeat(int iterations, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRepeat(iterations, (int i) -> runnable.run());
    }

    public TaskQueue thenRepeatAsynchronously(int iterations, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        for (int i = 0; i < iterations; ++i) {
            this.append(new Node(consumer, true));
        }
        return this;
    }

    public TaskQueue thenRepeatAsynchronously(int iterations, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRepeatAsynchronously(iterations, (int i) -> runnable.run());
    }

    public TaskQueue thenRepeatEvery(int ticks, int iterations, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ticks < 1) {
            throw new IllegalArgumentException("thenRepeatEvery() must be given a time that is greater than zero!");
        }
        for (int i = 0; i < iterations; ++i) {
            this.append(new Node(consumer, ticks, false));
        }
        return this;
    }

    public TaskQueue thenRepeatEvery(int ticks, int iterations, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRepeatEvery(ticks, iterations, (int i) -> runnable.run());
    }

    public TaskQueue thenRepeatEveryAsynchronously(int ticks, int iterations, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ticks < 1) {
            throw new IllegalArgumentException("thenRepeatEveryAsynchronously() must be given a time that is greater than zero!");
        }
        for (int i = 0; i < iterations; ++i) {
            this.append(new Node(consumer, ticks, true));
        }
        return this;
    }

    public TaskQueue thenRepeatEveryAsynchronously(int ticks, int iterations, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        return this.thenRepeatEveryAsynchronously(ticks, iterations, (int i) -> runnable.run());
    }

    public void thenLoop(@NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        Node node = new Node(consumer, false);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoop(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.thenLoop((int i) -> runnable.run());
    }

    public void thenLoopAsynchronously(@NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        Node node = new Node(consumer, true);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoopAsynchronously(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.thenLoopAsynchronously((int i) -> runnable.run());
    }

    public void thenLoopEvery(int ticks, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ticks < 1) {
            throw new IllegalArgumentException("thenLoopEvery() must be given a time that is greater than zero!");
        }
        Node node = new Node(consumer, ticks, false);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoopEvery(int ticks, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.thenLoopEvery(ticks, (int i) -> runnable.run());
    }

    public void thenLoopEveryAsynchronously(int ticks, @NonNull IntConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ticks < 1) {
            throw new IllegalArgumentException("thenLoopEveryAsynchronously() must be given a time that is greater than zero!");
        }
        Node node = new Node(consumer, ticks, true);
        node.setNextNode(node);
        this.append(node);
    }

    public void thenLoopEveryAsynchronously(int ticks, @NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.thenLoopEveryAsynchronously(ticks, (int i) -> runnable.run());
    }

    public TaskQueue thenWait(int ticks) {
        Node node = new Node(i -> {}, false);
        node.setDelay(ticks);
        return this.append(node);
    }

    private TaskQueue append(Node node) {
        if (this.head == null) {
            this.head = node;
        } else {
            Node current = this.head;
            while (current.hasNextNode()) {
                if (current == current.getNextNode()) {
                    throw new IllegalAccessError("You cannot append to a TaskQueue that contains a loop");
                }
                current = current.getNextNode();
            }
            current.setNextNode(node);
        }
        return this;
    }

    private class Node {
        private final IntConsumer runnable;
        private final boolean asynchronously;
        private int delay = 0;
        private Node nextNode;

        public Node(IntConsumer consumer, boolean async) {
            if (consumer == null) {
                throw new NullPointerException("consumer is marked non-null but is null");
            }
            this.runnable = consumer;
            this.asynchronously = async;
        }

        public Node(IntConsumer consumer, int delay, boolean async) {
            if (consumer == null) {
                throw new NullPointerException("consumer is marked non-null but is null");
            }
            this.runnable = consumer;
            this.delay = delay;
            this.asynchronously = async;
        }

        public boolean hasNextNode() {
            return this.nextNode != null;
        }

        public IntConsumer getRunnable() {
            return this.runnable;
        }

        public boolean isAsynchronously() {
            return this.asynchronously;
        }

        public int getDelay() {
            return this.delay;
        }

        public Node getNextNode() {
            return this.nextNode;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public void setNextNode(Node nextNode) {
            this.nextNode = nextNode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IntConsumer this$runnable = this.getRunnable();
            IntConsumer other$runnable = other.getRunnable();
            if (this$runnable == null ? other$runnable != null : !this$runnable.equals(other$runnable)) {
                return false;
            }
            if (this.isAsynchronously() != other.isAsynchronously()) {
                return false;
            }
            if (this.getDelay() != other.getDelay()) {
                return false;
            }
            Node this$nextNode = this.getNextNode();
            Node other$nextNode = other.getNextNode();
            return !(this$nextNode == null ? other$nextNode != null : !((Object)this$nextNode).equals(other$nextNode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IntConsumer $runnable = this.getRunnable();
            result = result * 59 + ($runnable == null ? 43 : $runnable.hashCode());
            result = result * 59 + (this.isAsynchronously() ? 79 : 97);
            result = result * 59 + this.getDelay();
            Node $nextNode = this.getNextNode();
            result = result * 59 + ($nextNode == null ? 43 : ((Object)$nextNode).hashCode());
            return result;
        }

        public String toString() {
            return "TaskQueue.Node(runnable=" + this.getRunnable() + ", asynchronously=" + this.isAsynchronously() + ", delay=" + this.getDelay() + ", nextNode=" + this.getNextNode() + ")";
        }
    }
}

