/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BlockListener
implements Listener {
    private final Set<Material> sensitiveMaterials = EnumSet.noneOf(Material.class);

    public BlockListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.sensitiveMaterials.add(Material.CAKE);
        this.sensitiveMaterials.add(Material.STONE_PRESSURE_PLATE);
        this.sensitiveMaterials.add(Material.LIGHT_WEIGHTED_PRESSURE_PLATE);
        this.sensitiveMaterials.add(Material.HEAVY_WEIGHTED_PRESSURE_PLATE);
        this.sensitiveMaterials.addAll(Tag.SAPLINGS.getValues());
        this.sensitiveMaterials.addAll(Tag.WOODEN_PRESSURE_PLATES.getValues());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockRegister(BlockPlaceEvent e) {
        if (BlockStorage.hasBlockInfo(e.getBlock())) {
            e.setCancelled(true);
            return;
        }
        ItemStack item = e.getItemInHand();
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem != null && Slimefun.isEnabled(e.getPlayer(), sfItem, true) && !(sfItem instanceof NotPlaceable)) {
            if (!Slimefun.hasUnlocked(e.getPlayer(), sfItem, true)) {
                e.setCancelled(true);
            } else {
                if (SlimefunPlugin.getBlockDataService().isTileEntity(e.getBlock().getType())) {
                    SlimefunPlugin.getBlockDataService().setBlockData(e.getBlock(), sfItem.getID());
                }
                BlockStorage.addBlockInfo(e.getBlock(), "id", sfItem.getID(), true);
                SlimefunBlockHandler blockHandler = SlimefunPlugin.getRegistry().getBlockHandlers().get(sfItem.getID());
                if (blockHandler != null) {
                    blockHandler.onPlace(e.getPlayer(), e.getBlock(), sfItem);
                }
                sfItem.callItemHandler(BlockPlaceHandler.class, handler -> handler.onPlayerPlace(e));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockUnregister(BlockBreakEvent e) {
        SlimefunItem tool;
        this.checkForSensitiveBlockAbove(e.getPlayer(), e.getBlock());
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand();
        int fortune = this.getBonusDropsWithFortune(item, e.getBlock());
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (item.getType() != Material.AIR && (tool = SlimefunItem.getByItem(item)) != null) {
            if (Slimefun.hasUnlocked(e.getPlayer(), tool, true)) {
                tool.callItemHandler(ToolUseHandler.class, handler -> handler.onToolUse(e, item, fortune, drops));
            } else {
                e.setCancelled(true);
            }
        }
        if (!e.isCancelled()) {
            Optional<String> blockData;
            SlimefunItem sfItem = BlockStorage.check(e.getBlock());
            if (sfItem == null && SlimefunPlugin.getBlockDataService().isTileEntity(e.getBlock().getType()) && (blockData = SlimefunPlugin.getBlockDataService().getBlockData(e.getBlock())).isPresent()) {
                sfItem = SlimefunItem.getByID(blockData.get());
            }
            if (sfItem != null && !sfItem.useVanillaBlockBreaking()) {
                SlimefunBlockHandler blockHandler = SlimefunPlugin.getRegistry().getBlockHandlers().get(sfItem.getID());
                if (blockHandler != null) {
                    if (!blockHandler.onBreak(e.getPlayer(), e.getBlock(), sfItem, UnregisterReason.PLAYER_BREAK)) {
                        e.setCancelled(true);
                        return;
                    }
                } else {
                    sfItem.callItemHandler(BlockBreakHandler.class, handler -> handler.onBlockBreak(e, item, fortune, drops));
                }
                drops.addAll(sfItem.getDrops());
                BlockStorage.clearBlockInfo(e.getBlock());
            }
        }
        this.dropItems(e, drops);
    }

    private void dropItems(BlockBreakEvent e, List<ItemStack> drops) {
        if (!drops.isEmpty()) {
            e.getBlock().setType(Material.AIR);
            if (e.isDropItems()) {
                for (ItemStack drop : drops) {
                    if (drop == null || drop.getType() == Material.AIR) continue;
                    e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), drop);
                }
            }
        }
    }

    private void checkForSensitiveBlockAbove(Player p, Block b) {
        SlimefunItem sfItem;
        Block blockAbove = b.getRelative(BlockFace.UP);
        if (this.sensitiveMaterials.contains(blockAbove.getType()) && (sfItem = BlockStorage.check(blockAbove)) != null && !sfItem.useVanillaBlockBreaking()) {
            SlimefunBlockHandler blockHandler = SlimefunPlugin.getRegistry().getBlockHandlers().get(sfItem.getID());
            if (blockHandler != null) {
                if (blockHandler.onBreak(p, blockAbove, sfItem, UnregisterReason.PLAYER_BREAK)) {
                    blockAbove.getWorld().dropItemNaturally(blockAbove.getLocation(), BlockStorage.retrieve(blockAbove));
                    blockAbove.setType(Material.AIR);
                }
            } else {
                blockAbove.getWorld().dropItemNaturally(blockAbove.getLocation(), BlockStorage.retrieve(blockAbove));
                blockAbove.setType(Material.AIR);
            }
        }
    }

    private int getBonusDropsWithFortune(ItemStack item, Block b) {
        int fortune = 1;
        if (item != null && item.getEnchantments().containsKey(Enchantment.LOOT_BONUS_BLOCKS) && !item.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int fortuneLevel = item.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS);
            fortune = Math.max(1, ((Random)random).nextInt(fortuneLevel + 2) - 1);
            fortune = (b.getType() == Material.LAPIS_ORE ? 4 + ((Random)random).nextInt(5) : 1) * (fortune + 1);
        }
        return fortune;
    }
}

