/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Locale;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.ChatColor;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class RepairedSpawner
extends SimpleSlimefunItem<BlockPlaceHandler> {
    public RepairedSpawner(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public BlockPlaceHandler getItemHandler() {
        return (p, e, item) -> {
            if (SlimefunUtils.isItemSimilar(item, SlimefunItems.REPAIRED_SPAWNER, false, false)) {
                Optional<EntityType> entity = this.getEntityType(item);
                if (entity.isPresent()) {
                    CreatureSpawner spawner = (CreatureSpawner)e.getBlock().getState();
                    spawner.setSpawnedType(entity.get());
                    spawner.update(true, false);
                }
                return true;
            }
            return false;
        };
    }

    public Optional<EntityType> getEntityType(ItemStack item) {
        for (String line : item.getItemMeta().getLore()) {
            if (!ChatColor.stripColor((String)line).startsWith("Type: ") || line.contains("<Type>")) continue;
            EntityType type = EntityType.valueOf((String)ChatColor.stripColor((String)line).replace("Type: ", "").replace(' ', '_').toUpperCase(Locale.ROOT));
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

