/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunBranch;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SupportedLanguage;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Localization;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class SlimefunLocalization
extends Localization
implements Keyed {
    public SlimefunLocalization(SlimefunPlugin plugin) {
        super((Plugin)plugin);
    }

    public abstract Language getLanguage(String var1);

    public abstract Language getLanguage(Player var1);

    public abstract Language getDefaultLanguage();

    protected abstract boolean hasLanguage(String var1);

    public abstract Collection<Language> getLanguages();

    protected abstract void addLanguage(String var1, String var2);

    protected void loadEmbeddedLanguages() {
        for (SupportedLanguage lang : SupportedLanguage.values()) {
            if (!lang.isReadyForRelease() && SlimefunPlugin.getUpdater().getBranch() == SlimefunBranch.STABLE) continue;
            this.addLanguage(lang.getLanguageId(), lang.getTexture());
        }
    }

    public String getMessage(Player p, String key) {
        Language language = this.getLanguage(p);
        if (language == null) {
            return "NO LANGUAGE FOUND";
        }
        String message = language.getMessagesFile().getString(key);
        if (message == null) {
            Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
            return fallback.getMessagesFile().getString(key);
        }
        return message;
    }

    public List<String> getMessages(Player p, String key) {
        Language language = this.getLanguage(p);
        if (language == null) {
            return Arrays.asList("NO LANGUAGE FOUND");
        }
        List messages = language.getMessagesFile().getStringList(key);
        if (messages.isEmpty()) {
            Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
            return fallback.getMessagesFile().getStringList(key);
        }
        return messages;
    }

    public String getResearchName(Player p, NamespacedKey key) {
        Language language = this.getLanguage(p);
        if (language.getResearchesFile() == null) {
            return null;
        }
        return language.getResearchesFile().getString(key.getNamespace() + "." + key.getKey());
    }

    public String getCategoryName(Player p, NamespacedKey key) {
        Language language = this.getLanguage(p);
        if (language.getCategoriesFile() == null) {
            return null;
        }
        return language.getCategoriesFile().getString(key.getNamespace() + "." + key.getKey());
    }

    public String getResourceString(Player p, String key) {
        String value;
        Language language = this.getLanguage(p);
        String string = value = language.getResourcesFile() != null ? language.getResourcesFile().getString(key) : null;
        if (value != null) {
            return value;
        }
        Language fallback = this.getLanguage(SupportedLanguage.ENGLISH.getLanguageId());
        return fallback.getResourcesFile().getString(key);
    }

    public ItemStack getRecipeTypeItem(Player p, RecipeType recipeType) {
        Language language = this.getLanguage(p);
        ItemStack item = recipeType.toItem();
        NamespacedKey key = recipeType.getKey();
        if (language.getRecipeTypesFile() == null || !language.getRecipeTypesFile().contains(key.getNamespace() + "." + key.getKey())) {
            language = this.getLanguage("en");
        }
        if (!language.getRecipeTypesFile().contains(key.getNamespace() + "." + key.getKey())) {
            return item;
        }
        FileConfiguration config = language.getRecipeTypesFile();
        return new CustomItem(item, meta -> {
            meta.setDisplayName(ChatColor.AQUA + config.getString(key.getNamespace() + "." + key.getKey() + ".name"));
            List lore = config.getStringList(key.getNamespace() + "." + key.getKey() + ".lore");
            lore.replaceAll(line -> ChatColor.GRAY + line);
            meta.setLore(lore);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        });
    }

    @Override
    public void sendMessage(CommandSender sender, String key, boolean addPrefix) {
        String prefix;
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (sender instanceof Player) {
            sender.sendMessage(ChatColors.color(prefix + this.getMessage((Player)sender, key)));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + this.getMessage(key))));
        }
    }

    @Override
    public void sendMessage(CommandSender sender, String key) {
        this.sendMessage(sender, key, true);
    }

    public void sendMessage(CommandSender sender, String key, UnaryOperator<String> function) {
        this.sendMessage(sender, key, true, function);
    }

    @Override
    public void sendMessage(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return;
        }
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (sender instanceof Player) {
            sender.sendMessage(ChatColors.color(prefix + (String)function.apply(this.getMessage((Player)sender, key))));
        } else {
            sender.sendMessage(ChatColor.stripColor((String)ChatColors.color(prefix + (String)function.apply(this.getMessage(key)))));
        }
    }

    @Override
    public void sendMessages(CommandSender sender, String key) {
        String prefix = this.getPrefix();
        if (sender instanceof Player) {
            for (String translation : this.getMessages((Player)sender, key)) {
                String message = ChatColors.color(prefix + translation);
                sender.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + translation);
                sender.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    @Override
    public void sendMessages(CommandSender sender, String key, boolean addPrefix, UnaryOperator<String> function) {
        String prefix;
        String string = prefix = addPrefix ? this.getPrefix() : "";
        if (sender instanceof Player) {
            for (String translation : this.getMessages((Player)sender, key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                sender.sendMessage(message);
            }
        } else {
            for (String translation : this.getMessages(key)) {
                String message = ChatColors.color(prefix + (String)function.apply(translation));
                sender.sendMessage(ChatColor.stripColor((String)message));
            }
        }
    }

    public void sendMessages(CommandSender sender, String key, UnaryOperator<String> function) {
        this.sendMessages(sender, key, true, function);
    }
}

