/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.List;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.Vein;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeOfVeinMining
extends SimpleSlimefunItem<BlockBreakHandler> {
    private final ItemSetting<Integer> maxBlocks = new ItemSetting<Integer>("max-blocks", Integer.valueOf(16)){

        @Override
        public boolean validateInput(Integer input) {
            return super.validateInput(input) && input > 0;
        }
    };

    public PickaxeOfVeinMining(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.maxBlocks);
    }

    @Override
    public BlockBreakHandler getItemHandler() {
        return new BlockBreakHandler(){

            @Override
            public boolean isPrivate() {
                return false;
            }

            @Override
            public boolean onBlockBreak(BlockBreakEvent e, ItemStack item, int fortune, List<ItemStack> drops) {
                if (MaterialCollections.getAllOres().contains(e.getBlock().getType()) && PickaxeOfVeinMining.this.isItem(item)) {
                    if (!Slimefun.hasUnlocked(e.getPlayer(), PickaxeOfVeinMining.this, true)) {
                        return true;
                    }
                    List<Block> blocks = Vein.find(e.getBlock(), (int)((Integer)PickaxeOfVeinMining.this.maxBlocks.getValue()), MaterialCollections.getAllOres());
                    PickaxeOfVeinMining.this.breakBlocks(e.getPlayer(), blocks, fortune);
                    return true;
                }
                return false;
            }
        };
    }

    private void breakBlocks(Player p, List<Block> blocks, int fortune) {
        for (Block b : blocks) {
            if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.BREAK_BLOCK)) continue;
            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
            for (ItemStack drop : b.getDrops(this.getItem())) {
                b.getWorld().dropItemNaturally(b.getLocation(), (ItemStack)(drop.getType().isBlock() ? drop : new CustomItem(drop, fortune)));
            }
            b.setType(Material.AIR);
        }
    }
}

