/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import me.mrCookieSlime.Slimefun.api.Slimefun;

public class MetricsService {
    private static final String REPO_NAME = "MetricsModule";
    private static final String GH_API = "https://api.github.com/repos/Slimefun/MetricsModule";
    private static final String GH_RELEASES = "https://github.com/Slimefun/MetricsModule/releases/download";
    private final SlimefunPlugin plugin;
    private final File parentFolder;
    private final File metricsModuleFile;
    private URLClassLoader moduleClassLoader;
    private String metricVersion = null;
    private boolean hasDownloadedUpdate = false;

    public MetricsService(SlimefunPlugin plugin) {
        this.plugin = plugin;
        this.parentFolder = new File(plugin.getDataFolder(), "cache" + File.separatorChar + "modules");
        if (!this.parentFolder.exists()) {
            this.parentFolder.mkdirs();
        }
        this.metricsModuleFile = new File(this.parentFolder, "MetricsModule.jar");
    }

    public void start() {
        if (!this.metricsModuleFile.exists()) {
            this.plugin.getLogger().info("MetricsModule does not exist, downloading...");
            if (!this.download(this.getLatestVersion())) {
                this.plugin.getLogger().warning("Failed to start metrics as the file could not be downloaded.");
                return;
            }
        }
        try {
            this.moduleClassLoader = URLClassLoader.newInstance(new URL[]{this.metricsModuleFile.toURI().toURL()}, this.plugin.getClass().getClassLoader());
            Class<?> metricsClass = this.moduleClassLoader.loadClass("dev.walshy.sfmetrics.MetricsModule");
            this.metricVersion = metricsClass.getPackage().getImplementationVersion();
            if (!this.hasDownloadedUpdate && this.hasAutoUpdates() && this.checkForUpdate(this.metricVersion)) {
                this.plugin.getLogger().info("Cleaning up and re-loading Metrics.");
                this.cleanUp();
                this.start();
                return;
            }
            Method start = metricsClass.getDeclaredMethod("start", new Class[0]);
            String version = metricsClass.getPackage().getImplementationVersion();
            Slimefun.runSync(() -> {
                try {
                    start.invoke(null, new Object[0]);
                    this.plugin.getLogger().info("Metrics build #" + version + " started.");
                }
                catch (Exception | LinkageError e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to start metrics.", e);
                }
            });
        }
        catch (Exception | LinkageError e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load the metrics module. Maybe the jar is corrupt?", e);
        }
    }

    public void cleanUp() {
        try {
            if (this.moduleClassLoader != null) {
                this.moduleClassLoader.close();
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not clean up module class loader. Some memory may have been leaked.");
        }
    }

    public boolean checkForUpdate(String currentVersion) {
        if (currentVersion == null || !PatternUtils.NUMERIC.matcher(currentVersion).matches()) {
            return false;
        }
        int latest = this.getLatestVersion();
        if (latest > Integer.parseInt(currentVersion)) {
            return this.download(latest);
        }
        return false;
    }

    private int getLatestVersion() {
        try {
            HttpResponse<JsonNode> response = Unirest.get("https://api.github.com/repos/Slimefun/MetricsModule/releases/latest").asJson();
            if (!response.isSuccess()) {
                return -1;
            }
            JsonNode node = response.getBody();
            if (node == null) {
                return -1;
            }
            return node.getObject().getInt("tag_name");
        }
        catch (UnirestException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to fetch latest builds for SFMetrics");
            return -1;
        }
    }

    private boolean download(int version) {
        File f = new File(this.parentFolder, "Metrics-" + version + ".jar");
        try {
            this.plugin.getLogger().log(Level.INFO, "# Starting download of MetricsModule build: #{0}", version);
            AtomicInteger lastPercentPosted = new AtomicInteger();
            GetRequest request = Unirest.get("https://github.com/Slimefun/MetricsModule/releases/download/" + version + "/" + REPO_NAME + ".jar");
            HttpResponse<File> response = ((GetRequest)request.downloadMonitor((b, fileName, bytesWritten, totalBytes) -> {
                int percent = (int)(20L * Math.round((double)bytesWritten.longValue() / (double)totalBytes.longValue() * 100.0 / 20.0));
                if (percent != 0 && percent != lastPercentPosted.get()) {
                    this.plugin.getLogger().info("# Downloading... " + percent + "% (" + bytesWritten + "/" + totalBytes + " bytes)");
                    lastPercentPosted.set(percent);
                }
            })).asFile(f.getPath());
            if (response.isSuccess()) {
                this.plugin.getLogger().log(Level.INFO, "Successfully downloaded {0} build: #{1}", new Object[]{REPO_NAME, version});
                Files.move(f.toPath(), this.metricsModuleFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.metricVersion = String.valueOf(version);
                this.hasDownloadedUpdate = true;
                return true;
            }
        }
        catch (UnirestException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to fetch the latest jar file from the builds page. Perhaps GitHub is down.");
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to replace the old metric file with the new one. Please do this manually! Error: {0}", e.getMessage());
        }
        return false;
    }

    @Nullable
    public String getVersion() {
        return this.metricVersion;
    }

    public boolean hasAutoUpdates() {
        return SlimefunPlugin.instance().getConfig().getBoolean("metrics.auto-update");
    }

    static {
        Unirest.config().concurrency(2, 1).setDefaultHeader("User-Agent", "MetricsModule Auto-Updater").setDefaultHeader("Accept", "application/vnd.github.v3+json").enableCookieManagement(false).cookieSpec("ignoreCookies");
    }
}

