/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.guide;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.LoopIterator;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.plugin.Plugin;

class RecipeChoiceTask
implements Runnable {
    private static final int UPDATE_INTERVAL = 14;
    private Inventory inventory;
    private int id;
    private final Map<Integer, LoopIterator<Material>> iterators = new HashMap<Integer, LoopIterator<Material>>();

    RecipeChoiceTask() {
    }

    public void start(Inventory inv) {
        Validate.notNull((Object)inv, (String)"Inventory must not be null");
        this.inventory = inv;
        this.id = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SlimefunPlugin.instance(), (Runnable)this, 0L, 14L).getTaskId();
    }

    public void add(int slot, RecipeChoice.MaterialChoice choice) {
        Validate.notNull((Object)choice, (String)"Cannot add a null RecipeChoice");
        this.iterators.put(slot, new LoopIterator(choice.getChoices()));
    }

    public void add(int slot, Tag<Material> tag) {
        Validate.notNull(tag, (String)"Cannot add a null Tag");
        this.iterators.put(slot, new LoopIterator(tag.getValues()));
    }

    public boolean isEmpty() {
        return this.iterators.isEmpty();
    }

    @Override
    public void run() {
        if (this.inventory.getViewers().isEmpty()) {
            Bukkit.getScheduler().cancelTask(this.id);
            return;
        }
        for (Map.Entry<Integer, LoopIterator<Material>> entry : this.iterators.entrySet()) {
            this.inventory.setItem(entry.getKey().intValue(), new ItemStack(entry.getValue().next()));
        }
    }
}

