/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import kong.unirest.json.JSONException;
import me.mrCookieSlime.Slimefun.api.Slimefun;

abstract class GitHubConnector {
    protected File file;
    protected String repository;
    protected final GitHubService github;

    public GitHubConnector(GitHubService github, String repository) {
        this.github = github;
        this.repository = repository;
    }

    public abstract String getFileName();

    public abstract String getURLSuffix();

    public abstract void onSuccess(JsonNode var1);

    public void onFailure() {
    }

    public void pullFile() {
        this.file = new File("plugins/Slimefun/cache/github/" + this.getFileName() + ".json");
        if (this.github.isLoggingEnabled()) {
            Slimefun.getLogger().log(Level.INFO, "Retrieving {0}.json from GitHub...", this.getFileName());
        }
        try {
            HttpResponse<JsonNode> resp = ((GetRequest)Unirest.get("https://api.github.com/repos/" + this.repository + this.getURLSuffix()).header("User-Agent", "Slimefun4 (https://github.com/Slimefun)")).asJson();
            if (resp.isSuccess()) {
                this.onSuccess(resp.getBody());
                this.writeCacheFile(resp.getBody());
            } else {
                Slimefun.getLogger().log(Level.WARNING, "Failed to fetch {0}: {1} - {2}", new Object[]{this.repository + this.getURLSuffix(), resp.getStatus(), resp.getBody().toString()});
            }
        }
        catch (UnirestException e) {
            JsonNode cache;
            if (this.github.isLoggingEnabled()) {
                Slimefun.getLogger().log(Level.WARNING, "Could not connect to GitHub in time.");
            }
            if (this.file.exists() && (cache = this.readCacheFile()) != null) {
                this.onSuccess(cache);
                return;
            }
            this.onFailure();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode readCacheFile() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));){
            JsonNode jsonNode = new JsonNode(reader.readLine());
            return jsonNode;
        }
        catch (IOException | JSONException e) {
            Slimefun.getLogger().log(Level.WARNING, "Failed to read Github cache file: {0} - {1}: {2}", new Object[]{this.file.getName(), e.getClass().getSimpleName(), e.getMessage()});
            return null;
        }
    }

    private void writeCacheFile(JsonNode node) {
        try (FileOutputStream output = new FileOutputStream(this.file);){
            output.write(node.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            Slimefun.getLogger().log(Level.WARNING, "Failed to populate GitHub cache: {0} - {1}", new Object[]{e.getClass().getSimpleName(), e.getMessage()});
        }
    }
}

