/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Locale;
import org.bukkit.ChatColor;

public final class NumberUtils {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    private NumberUtils() {
    }

    public static String formatBigNumber(int i) {
        return NumberFormat.getNumberInstance(Locale.US).format(i);
    }

    public static LocalDateTime parseGitHubDate(String date) {
        return LocalDateTime.parse(date.substring(0, date.length() - 1));
    }

    public static ChatColor getColorFromPercentage(float percentage) {
        if (percentage < 16.0f) {
            return ChatColor.DARK_RED;
        }
        if (percentage < 32.0f) {
            return ChatColor.RED;
        }
        if (percentage < 48.0f) {
            return ChatColor.GOLD;
        }
        if (percentage < 64.0f) {
            return ChatColor.YELLOW;
        }
        if (percentage < 80.0f) {
            return ChatColor.DARK_GREEN;
        }
        return ChatColor.GREEN;
    }

    public static String getElapsedTime(LocalDateTime date) {
        long hours = Duration.between(date, LocalDateTime.now()).toHours();
        if (hours == 0L) {
            return "< 1h";
        }
        if (hours / 24L == 0L) {
            return hours % 24L + "h";
        }
        if (hours % 24L == 0L) {
            return hours / 24L + "d";
        }
        return hours / 24L + "d " + hours % 24L + "h";
    }

    public static String getTimeLeft(int seconds) {
        String timeleft = "";
        int minutes = (int)((long)seconds / 60L);
        if (minutes > 0) {
            timeleft = timeleft + minutes + "m ";
        }
        return timeleft + (seconds -= minutes * 60) + "s";
    }

    public static int getInt(String str, int defaultValue) {
        if (PatternUtils.NUMERIC.matcher(str).matches()) {
            return Integer.parseInt(str);
        }
        return defaultValue;
    }

    public static String getAsMillis(long nanoseconds) {
        if (nanoseconds == 0L) {
            return "0ms";
        }
        String number = NumberUtils.roundDecimalNumber((double)nanoseconds / 1000000.0);
        String[] parts = PatternUtils.NUMBER_SEPERATOR.split(number);
        if (parts.length == 1) {
            return parts[0] + "ms";
        }
        return parts[0] + '.' + parts[1] + "ms";
    }

    public static String roundDecimalNumber(double number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static long getLong(Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static int getInt(Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static float getFloat(Float value, float defaultValue) {
        return value == null ? defaultValue : value.floatValue();
    }
}

