/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.stream.Collectors;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Juicer
extends MultiBlockMachine {
    public Juicer(Category category, SlimefunItemStack item) {
        super(category, item, new ItemStack[]{null, new ItemStack(Material.GLASS), null, null, new ItemStack(Material.NETHER_BRICK_FENCE), null, null, new CustomItem(Material.DISPENSER, "Dispenser (Facing up)", new String[0]), null}, new ItemStack[0], BlockFace.SELF);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes.stream().map(items -> items[0]).collect(Collectors.toList());
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(dispBlock, false).getState();
        if (state instanceof Dispenser) {
            Dispenser disp = (Dispenser)state;
            Inventory inv = disp.getInventory();
            for (ItemStack current : inv.getContents()) {
                for (ItemStack convert : RecipeType.getRecipeInputs(this)) {
                    if (convert == null || !SlimefunUtils.isItemSimilar(current, convert, true)) continue;
                    ItemStack adding = RecipeType.getRecipeOutput(this, convert);
                    Inventory outputInv = this.findOutputInventory(adding, dispBlock, inv);
                    if (outputInv != null) {
                        ItemStack removing = current.clone();
                        removing.setAmount(1);
                        inv.removeItem(new ItemStack[]{removing});
                        outputInv.addItem(new ItemStack[]{adding});
                        p.getWorld().playSound(b.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f);
                        p.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)Material.HAY_BLOCK);
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
                    }
                    return;
                }
            }
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
        }
    }
}

