/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.guide;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.categories.FlexCategory;
import io.github.thebusybiscuit.slimefun4.core.categories.LockedCategory;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideLayout;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatInput;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ChatComponent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.ClickEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.CustomBookInterface;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.json.HoverEvent;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BookSlimefunGuide
implements SlimefunGuideImplementation {
    private final NamespacedKey guideSearch = new NamespacedKey((Plugin)SlimefunPlugin.instance, "search");

    @Override
    public SlimefunGuideLayout getLayout() {
        return SlimefunGuideLayout.BOOK;
    }

    @Override
    public boolean isSurvivalMode() {
        return true;
    }

    @Override
    public ItemStack getItem() {
        return new CustomItem(new ItemStack(Material.ENCHANTED_BOOK), "&aSlimefun Guide &7(Book GUI)", "", "&eRight Click &8\u21e8 &7Browse Items", "&eShift + Right Click &8\u21e8 &7Open Settings / Credits");
    }

    private void openBook(Player p, PlayerProfile profile, List<ChatComponent> lines, boolean backButton) {
        CustomBookInterface book = new CustomBookInterface((Plugin)SlimefunPlugin.instance);
        book.setTitle(SlimefunPlugin.getLocalization().getMessage(p, "guide.title.main"));
        for (int i = 0; i < lines.size(); i += 10) {
            ChatComponent page = new ChatComponent("");
            ChatComponent header = new ChatComponent(ChatColors.color("&b&l- " + SlimefunPlugin.getLocalization().getMessage(p, "guide.title.main") + " -\n\n"));
            header.setHoverEvent(new HoverEvent(ChestMenuUtils.getSearchButton(p)));
            header.setClickEvent(new ClickEvent(this.guideSearch, player -> Slimefun.runSync(() -> {
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)player, "guide.search.message");
                ChatInput.waitForPlayer((Plugin)SlimefunPlugin.instance, player, msg -> SlimefunGuide.openSearch(profile, msg, true, true));
            }, 1L)));
            page.append(header);
            for (int j = i; j < lines.size() && j < i + 10; ++j) {
                page.append(lines.get(j));
            }
            page.append(new ChatComponent("\n"));
            if (backButton) {
                ChatComponent button = new ChatComponent(ChatColor.DARK_BLUE + "\u21e6 " + SlimefunPlugin.getLocalization().getMessage(p, "guide.back.title"));
                button.setHoverEvent(new HoverEvent(ChatColor.DARK_BLUE + "\u21e6 " + SlimefunPlugin.getLocalization().getMessage(p, "guide.back.title"), "", ChatColor.GRAY + SlimefunPlugin.getLocalization().getMessage(p, "guide.back.guide")));
                button.setClickEvent(new ClickEvent(new NamespacedKey((Plugin)SlimefunPlugin.instance, "slimefun_guide"), pl -> this.openMainMenu(profile, 1)));
                page.append(button);
            }
            book.addPage(page);
        }
        book.open(p);
    }

    @Override
    public void openMainMenu(PlayerProfile profile, int page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        LinkedList<ChatComponent> lines = new LinkedList<ChatComponent>();
        int tier = 0;
        for (Category category : SlimefunPlugin.getRegistry().getCategories()) {
            if (category.isHidden(p) || category instanceof FlexCategory && !((FlexCategory)category).isVisible(p, profile, this.getLayout())) continue;
            if (tier < category.getTier()) {
                tier = category.getTier();
                if (tier > 1) {
                    for (int i = 0; i < 10 && lines.size() % 10 != 0; ++i) {
                        lines.add(new ChatComponent("\n"));
                    }
                }
                lines.add(new ChatComponent(ChatColor.DARK_GRAY + "\u21e8" + ChatColor.DARK_BLUE + " Tier " + tier + "\n"));
            }
            if (category instanceof LockedCategory && !((LockedCategory)category).hasUnlocked(p, profile)) {
                LinkedList<String> lore = new LinkedList<String>();
                lore.add(ChatColor.DARK_RED + SlimefunPlugin.getLocalization().getMessage(p, "guide.locked") + " " + ChatColor.GRAY + "- " + ChatColor.RESET + category.getItem(p).getItemMeta().getDisplayName());
                lore.add("");
                for (String line : SlimefunPlugin.getLocalization().getMessages(p, "guide.locked-category")) {
                    lore.add(ChatColor.RESET + line);
                }
                lore.add("");
                for (Category parent : ((LockedCategory)category).getParents()) {
                    lore.add(parent.getItem(p).getItemMeta().getDisplayName());
                }
                ChatComponent chatComponent = new ChatComponent(ChatUtils.crop(ChatColor.RED, ItemUtils.getItemName(category.getItem(p))) + "\n");
                chatComponent.setHoverEvent(new HoverEvent(lore));
                lines.add(chatComponent);
                continue;
            }
            ChatComponent chatComponent = new ChatComponent(ChatUtils.crop(ChatColor.DARK_GREEN, ItemUtils.getItemName(category.getItem(p))) + "\n");
            chatComponent.setHoverEvent(new HoverEvent(ItemUtils.getItemName(category.getItem(p)), "", ChatColor.GRAY + "\u21e8 " + ChatColor.GREEN + SlimefunPlugin.getLocalization().getMessage(p, "guide.tooltips.open-category")));
            chatComponent.setClickEvent(new ClickEvent(category.getKey(), pl -> this.openCategory(profile, category, 1)));
            lines.add(chatComponent);
        }
        this.openBook(p, profile, lines, false);
    }

    @Override
    public void openCategory(PlayerProfile profile, Category category, int page) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        if (category instanceof FlexCategory) {
            ((FlexCategory)category).open(p, profile, this.getLayout());
        } else if (category.getItems().size() < 250) {
            profile.getGuideHistory().add(category, page);
            LinkedList<ChatComponent> items = new LinkedList<ChatComponent>();
            for (SlimefunItem item : category.getItems()) {
                if (Slimefun.hasPermission(p, item, false)) {
                    if (!Slimefun.isEnabled(p, item, false)) continue;
                    this.appendSlimefunItem(category, page, p, profile, item, items);
                    continue;
                }
                ChatComponent component = new ChatComponent(ChatUtils.crop(ChatColor.DARK_RED, ItemUtils.getItemName(item.getItem())) + "\n");
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(ChatColor.DARK_RED + ChatColor.stripColor((String)ItemUtils.getItemName(item.getItem())));
                lore.add("");
                for (String line : SlimefunPlugin.getPermissionsService().getLore(item)) {
                    lore.add(ChatColors.color(line));
                }
                component.setHoverEvent(new HoverEvent(lore));
                items.add(component);
            }
            this.openBook(p, profile, items, true);
        } else {
            p.sendMessage(ChatColor.RED + "That Category is too big to open :/");
        }
    }

    private void appendSlimefunItem(Category category, int page, Player p, PlayerProfile profile, SlimefunItem item, List<ChatComponent> items) {
        NamespacedKey key = new NamespacedKey((Plugin)SlimefunPlugin.instance, item.getID().toLowerCase(Locale.ROOT));
        if (!Slimefun.hasUnlocked(p, item, false) && item.getResearch() != null) {
            Research research = item.getResearch();
            ChatComponent component = new ChatComponent(ChatUtils.crop(ChatColor.RED, item.getItemName()) + "\n");
            component.setHoverEvent(new HoverEvent(ChatColor.RESET + item.getItemName(), ChatColor.DARK_RED.toString() + ChatColor.BOLD + SlimefunPlugin.getLocalization().getMessage(p, "guide.locked"), "", ChatColor.GREEN + "> Click to unlock", "", ChatColor.GRAY + "Cost: " + ChatColor.AQUA.toString() + research.getCost() + " Level(s)"));
            component.setClickEvent(new ClickEvent(key, player -> Slimefun.runSync(() -> {
                if (!SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().contains(p.getUniqueId())) {
                    if (research.canUnlock(p)) {
                        if (profile.hasUnlocked(research)) {
                            this.openCategory(profile, category, page);
                        } else {
                            this.unlockItem(p, item, pl -> this.openCategory(profile, category, page));
                        }
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.not-enough-xp", true);
                    }
                }
            })));
            items.add(component);
        } else {
            ChatComponent component = new ChatComponent(ChatUtils.crop(ChatColor.DARK_GREEN, item.getItemName()) + "\n");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(item.getItemName());
            if (item.getItem().hasItemMeta() && item.getItem().getItemMeta().hasLore()) {
                lore.addAll(item.getItem().getItemMeta().getLore());
            }
            component.setHoverEvent(new HoverEvent(lore));
            component.setClickEvent(new ClickEvent(key, player -> Slimefun.runSync(() -> this.displayItem(profile, item, true))));
            items.add(component);
        }
    }

    @Override
    public void openSearch(PlayerProfile profile, String input, boolean addToHistory) {
        SlimefunGuide.openSearch(profile, input, true, addToHistory);
    }

    @Override
    public void displayItem(PlayerProfile profile, ItemStack item, int index, boolean addToHistory) {
        SlimefunGuide.displayItem(profile, item, addToHistory);
    }

    @Override
    public void displayItem(PlayerProfile profile, SlimefunItem item, boolean addToHistory) {
        SlimefunGuide.displayItem(profile, item, addToHistory);
    }
}

