/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.ContributionsConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.players.MinecraftAccount;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

class GitHubTask
implements Runnable {
    private static final int MAX_REQUESTS_PER_MINUTE = 16;
    private final GitHubService gitHubService;

    GitHubTask(GitHubService github) {
        this.gitHubService = github;
    }

    @Override
    public void run() {
        this.gitHubService.getConnectors().forEach(GitHubConnector::pullFile);
        this.grabTextures();
    }

    private void grabTextures() {
        Contributor contributor;
        int newRequests;
        HashMap<String, String> skins = new HashMap<String, String>();
        int requests = 0;
        Iterator<Object> iterator = this.gitHubService.getContributors().values().iterator();
        while (iterator.hasNext() && (newRequests = this.requestTexture(contributor = (Contributor)iterator.next(), skins)) >= 0 && (requests += newRequests) < 16) {
        }
        if (requests >= 16 && SlimefunPlugin.instance != null && SlimefunPlugin.instance.isEnabled()) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SlimefunPlugin.instance, this::grabTextures, 2400L);
        }
        for (GitHubConnector connector : this.gitHubService.getConnectors()) {
            if (!(connector instanceof ContributionsConnector) || ((ContributionsConnector)connector).hasFinished()) continue;
            return;
        }
        this.gitHubService.saveCache();
    }

    private int requestTexture(Contributor contributor, Map<String, String> skins) {
        if (!contributor.hasTexture()) {
            try {
                if (!skins.containsKey(contributor.getMinecraftName())) {
                    contributor.setTexture(this.pullTexture(skins, contributor));
                    return contributor.getUniqueId().isPresent() ? 1 : 2;
                }
                contributor.setTexture(skins.get(contributor.getMinecraftName()));
            }
            catch (IllegalArgumentException x) {
                contributor.setTexture(null);
            }
            catch (IOException x) {
                Slimefun.getLogger().log(Level.WARNING, "Attempted to connect to mojang.com, got this response: {0}: {1}", new Object[]{x.getClass().getSimpleName(), x.getMessage()});
                Slimefun.getLogger().log(Level.WARNING, "This usually means mojang.com is down or started to rate-limit this connection, this is not an error message!");
                if (x.getMessage().contains("429")) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SlimefunPlugin.instance, this::grabTextures, 6000L);
                }
                return -1;
            }
            catch (MinecraftAccount.TooManyRequestsException x) {
                Slimefun.getLogger().log(Level.WARNING, "Received a rate-limit from mojang.com, retrying in 4 minutes");
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)SlimefunPlugin.instance, this::grabTextures, 4800L);
                return -1;
            }
        }
        return 0;
    }

    private String pullTexture(Map<String, String> skins, Contributor contributor) throws MinecraftAccount.TooManyRequestsException, IOException {
        Optional<UUID> uuid = contributor.getUniqueId();
        if (!uuid.isPresent() && (uuid = MinecraftAccount.getUUID(contributor.getMinecraftName())).isPresent()) {
            contributor.setUniqueId(uuid.get());
        }
        if (uuid.isPresent()) {
            Optional<String> skin = MinecraftAccount.getSkin(uuid.get());
            skins.put(contributor.getMinecraftName(), skin.orElse(""));
            return skin.orElse(null);
        }
        return null;
    }
}

