/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockInfoConfig;
import me.mrCookieSlime.Slimefun.api.EmptyBlockData;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public class BlockStorage {
    private static final String PATH_BLOCKS = "data-storage/Slimefun/stored-blocks/";
    private static final String PATH_CHUNKS = "data-storage/Slimefun/stored-chunks/";
    private static final String PATH_INVENTORIES = "data-storage/Slimefun/stored-inventories/";
    private static final EmptyBlockData emptyBlockData = new EmptyBlockData();
    private final World world;
    private final Map<Location, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config> storage = new ConcurrentHashMap<Location, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config>();
    private final Map<Location, BlockMenu> inventories = new ConcurrentHashMap<Location, BlockMenu>();
    private final Map<String, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config> blocksCache = new ConcurrentHashMap<String, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config>();
    private static int chunkChanges = 0;
    private int changes = 0;

    public static BlockStorage getStorage(World world) {
        return SlimefunPlugin.getRegistry().getWorlds().get(world.getName());
    }

    public static BlockStorage getForcedStorage(World world) {
        return BlockStorage.isWorldRegistered(world.getName()) ? SlimefunPlugin.getRegistry().getWorlds().get(world.getName()) : new BlockStorage(world);
    }

    private static String serializeLocation(Location l) {
        return l.getWorld().getName() + ';' + l.getBlockX() + ';' + l.getBlockY() + ';' + l.getBlockZ();
    }

    private static String locationToChunkString(Location l) {
        return l.getWorld().getName() + ";Chunk;" + (l.getBlockX() >> 4) + ';' + (l.getBlockZ() >> 4);
    }

    private static String serializeChunk(World world, int x, int z) {
        return world.getName() + ";Chunk;" + x + ';' + z;
    }

    private static Location deserializeLocation(String l) {
        try {
            String[] components = PatternUtils.SEMICOLON.split(l);
            if (components.length != 4) {
                return null;
            }
            World w = Bukkit.getWorld((String)components[0]);
            if (w != null) {
                return new Location(w, (double)Integer.parseInt(components[1]), (double)Integer.parseInt(components[2]), (double)Integer.parseInt(components[3]));
            }
        }
        catch (NumberFormatException x) {
            Slimefun.getLogger().log(Level.WARNING, "Could not parse Number", x);
        }
        return null;
    }

    public BlockStorage(World w) {
        this.world = w;
        if (this.world.getName().indexOf(46) != -1) {
            throw new IllegalArgumentException("Slimefun cannot deal with World names that contain a dot: " + w.getName());
        }
        if (SlimefunPlugin.getRegistry().getWorlds().containsKey(w.getName())) {
            return;
        }
        Slimefun.getLogger().log(Level.INFO, "Loading Blocks for World \"{0}\"", w.getName());
        Slimefun.getLogger().log(Level.INFO, "This may take a long time...");
        File dir = new File(PATH_BLOCKS + w.getName());
        if (dir.exists()) {
            this.loadBlocks(dir);
        } else {
            dir.mkdirs();
        }
        this.loadChunks();
        this.loadInventories();
        SlimefunPlugin.getRegistry().getWorlds().put(this.world.getName(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlocks(File directory) {
        long total = directory.listFiles().length;
        long start = System.currentTimeMillis();
        long done = 0L;
        long timestamp = System.currentTimeMillis();
        long totalBlocks = 0L;
        int delay = SlimefunPlugin.getCfg().getInt("URID.info-delay");
        try {
            for (File file : directory.listFiles()) {
                if (file.getName().equals("null.sfb")) {
                    Slimefun.getLogger().log(Level.WARNING, "File with corrupted blocks detected!");
                    Slimefun.getLogger().log(Level.WARNING, "Slimefun will simply skip this File, you should look inside though!");
                    Slimefun.getLogger().log(Level.WARNING, file.getPath());
                    continue;
                }
                if (!file.getName().endsWith(".sfb")) continue;
                if (timestamp + (long)delay < System.currentTimeMillis()) {
                    int progress = Math.round((float)done * 100.0f / (float)total * 100.0f / 100.0f);
                    Slimefun.getLogger().log(Level.INFO, "Loading Blocks... {0}% done (\"{1}\")", new Object[]{progress, this.world.getName()});
                    timestamp = System.currentTimeMillis();
                }
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
                for (String key : cfg.getKeys(false)) {
                    Location l = BlockStorage.deserializeLocation(key);
                    String chunkString = BlockStorage.locationToChunkString(l);
                    try {
                        ++totalBlocks;
                        String json = cfg.getString(key);
                        BlockInfoConfig blockInfo = BlockStorage.parseBlockInfo(l, json);
                        if (blockInfo == null || !blockInfo.contains("id")) continue;
                        if (this.storage.containsKey(l)) {
                            Slimefun.getLogger().log(Level.INFO, "Ignoring duplicate block @ {0}, {1}, {2}", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ()});
                            Slimefun.getLogger().log(Level.INFO, "New: {0} | Old: {1}", new Object[]{key, BlockStorage.serializeBlockInfo(this.storage.get(l))});
                            continue;
                        }
                        this.storage.put(l, blockInfo);
                        if (!SlimefunPlugin.getRegistry().getTickerBlocks().contains(file.getName().replace(".sfb", ""))) continue;
                        Set locations = SlimefunPlugin.getRegistry().getActiveTickers().getOrDefault(chunkString, new HashSet());
                        locations.add(l);
                        SlimefunPlugin.getRegistry().getActiveTickers().put(chunkString, locations);
                        if (SlimefunPlugin.getRegistry().getActiveChunks().contains(chunkString)) continue;
                        SlimefunPlugin.getRegistry().getActiveChunks().add(chunkString);
                    }
                    catch (Exception x) {
                        Slimefun.getLogger().log(Level.WARNING, x, () -> "Failed to load " + file.getName() + '(' + key + ") for Slimefun " + SlimefunPlugin.getVersion());
                    }
                }
                ++done;
            }
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - start;
            Slimefun.getLogger().log(Level.INFO, "Loading Blocks... 100% (FINISHED - {0}ms)", time);
            Slimefun.getLogger().log(Level.INFO, "Loaded a total of {0} Blocks for World \"{1}\"", new Object[]{totalBlocks, this.world.getName()});
            if (totalBlocks > 0L) {
                Slimefun.getLogger().log(Level.INFO, "Avg: {0}ms/Block", DoubleHandler.fixDouble((double)time / (double)totalBlocks, 3));
            }
            throw throwable;
        }
        long time = System.currentTimeMillis() - start;
        Slimefun.getLogger().log(Level.INFO, "Loading Blocks... 100% (FINISHED - {0}ms)", time);
        Slimefun.getLogger().log(Level.INFO, "Loaded a total of {0} Blocks for World \"{1}\"", new Object[]{totalBlocks, this.world.getName()});
        if (totalBlocks > 0L) {
            Slimefun.getLogger().log(Level.INFO, "Avg: {0}ms/Block", DoubleHandler.fixDouble((double)time / (double)totalBlocks, 3));
        }
    }

    private void loadChunks() {
        File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
        if (chunks.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)chunks);
            for (String key : cfg.getKeys(false)) {
                try {
                    if (!this.world.getName().equals(PatternUtils.SEMICOLON.split(key)[0])) continue;
                    SlimefunPlugin.getRegistry().getChunks().put(key, new BlockInfoConfig(BlockStorage.parseJSON(cfg.getString(key))));
                }
                catch (Exception x) {
                    Slimefun.getLogger().log(Level.WARNING, x, () -> "Failed to load " + chunks.getName() + " in World " + this.world.getName() + '(' + key + ") for Slimefun " + SlimefunPlugin.getVersion());
                }
            }
        }
    }

    private void loadInventories() {
        for (File file : new File("data-storage/Slimefun/stored-inventories").listFiles()) {
            if (!file.getName().startsWith(this.world.getName()) || !file.getName().endsWith(".sfi")) continue;
            try {
                Location l = BlockStorage.deserializeLocation(file.getName().replace(".sfi", ""));
                Config cfg = new Config(file);
                BlockMenuPreset preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
                if (preset == null) {
                    preset = BlockMenuPreset.getPreset(BlockStorage.checkID(l));
                }
                if (preset == null) continue;
                this.inventories.put(l, new BlockMenu(preset, l, cfg));
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while loading this Block Inventory: " + file.getName());
            }
        }
        for (File file : new File("data-storage/Slimefun/universal-inventories").listFiles()) {
            if (!file.getName().endsWith(".sfi")) continue;
            try {
                Config cfg = new Config(file);
                BlockMenuPreset preset = BlockMenuPreset.getPreset(cfg.getString("preset"));
                if (preset == null) continue;
                SlimefunPlugin.getRegistry().getUniversalInventories().put(preset.getID(), new UniversalBlockMenu(preset, cfg));
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while loading this universal Inventory: " + file.getName());
            }
        }
    }

    public void computeChanges() {
        this.changes = this.blocksCache.size() + chunkChanges;
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            this.changes += ((BlockMenu)((Object)entry.getValue())).getUnsavedChanges();
        }
        HashMap<String, UniversalBlockMenu> universalInventories2 = new HashMap<String, UniversalBlockMenu>(SlimefunPlugin.getRegistry().getUniversalInventories());
        for (Map.Entry entry : universalInventories2.entrySet()) {
            this.changes += ((UniversalBlockMenu)((Object)entry.getValue())).getUnsavedChanges();
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public void save(boolean remove) {
        this.save(true, remove);
    }

    public void save(boolean computeChanges, boolean remove) {
        if (computeChanges) {
            this.computeChanges();
        }
        if (this.changes == 0) {
            return;
        }
        Slimefun.getLogger().log(Level.INFO, "Saving Blocks for World \"{0}\" ({1} Change(s) queued)", new Object[]{this.world.getName(), this.changes});
        HashMap<String, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config> cache = new HashMap<String, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config>(this.blocksCache);
        for (Map.Entry entry : cache.entrySet()) {
            this.blocksCache.remove(entry.getKey());
            me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config config = (me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config)entry.getValue();
            if (config.getKeys().isEmpty()) {
                File file = config.getFile();
                if (!file.exists()) continue;
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    Slimefun.getLogger().log(Level.WARNING, e, () -> "Could not delete file \"" + file.getName() + '\"');
                }
                continue;
            }
            File tmpFile = new File(config.getFile().getParentFile(), config.getFile().getName() + ".tmp");
            config.save(tmpFile);
            try {
                Files.move(tmpFile.toPath(), config.getFile().toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException x) {
                Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while copying a temporary File for Slimefun " + SlimefunPlugin.getVersion());
            }
        }
        HashMap<Location, BlockMenu> inventories2 = new HashMap<Location, BlockMenu>(this.inventories);
        for (Map.Entry entry : inventories2.entrySet()) {
            ((BlockMenu)((Object)entry.getValue())).save((Location)entry.getKey());
        }
        HashMap<String, UniversalBlockMenu> hashMap = new HashMap<String, UniversalBlockMenu>(SlimefunPlugin.getRegistry().getUniversalInventories());
        for (Map.Entry entry : hashMap.entrySet()) {
            ((UniversalBlockMenu)((Object)entry.getValue())).save();
        }
        if (chunkChanges > 0) {
            this.saveChunks(remove);
        }
        this.changes = 0;
        chunkChanges = 0;
    }

    private void saveChunks(boolean remove) {
        File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
        me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg = new me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config("data-storage/Slimefun/stored-chunks/chunks.temp");
        for (Map.Entry<String, BlockInfoConfig> entry : SlimefunPlugin.getRegistry().getChunks().entrySet()) {
            if (entry.getValue().getKeys().isEmpty()) continue;
            cfg.setValue(entry.getKey(), (Object)entry.getValue().toJSON());
        }
        cfg.save(chunks);
        if (remove) {
            SlimefunPlugin.getRegistry().getWorlds().remove(this.world.getName());
        }
    }

    public static void store(Block block, ItemStack item) {
        SlimefunItem sfitem = SlimefunItem.getByItem(item);
        if (sfitem != null) {
            BlockStorage.addBlockInfo(block, "id", sfitem.getID(), true);
        }
    }

    public static void store(Block block, String item) {
        BlockStorage.addBlockInfo(block, "id", item, true);
    }

    public static ItemStack retrieve(Block block) {
        if (!BlockStorage.hasBlockInfo(block)) {
            return null;
        }
        SlimefunItem item = SlimefunItem.getByID(BlockStorage.getLocationInfo(block.getLocation(), "id"));
        BlockStorage.clearBlockInfo(block);
        if (item == null) {
            return null;
        }
        return item.getItem();
    }

    public static me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config getLocationInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg = storage.storage.get(l);
        return cfg == null ? emptyBlockData : cfg;
    }

    private static Map<String, String> parseJSON(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (json != null && json.length() > 2) {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(json).getAsJsonObject();
            for (Map.Entry entry : obj.entrySet()) {
                map.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        return map;
    }

    private static BlockInfoConfig parseBlockInfo(Location l, String json) {
        try {
            return new BlockInfoConfig(BlockStorage.parseJSON(json));
        }
        catch (Exception x) {
            Logger logger = Slimefun.getLogger();
            logger.log(Level.WARNING, x.getClass().getName());
            logger.log(Level.WARNING, "Failed to parse BlockInfo for Block @ {0}, {1}, {2}", new Object[]{l.getBlockX(), l.getBlockY(), l.getBlockZ()});
            logger.log(Level.WARNING, json);
            logger.log(Level.WARNING, "");
            logger.log(Level.WARNING, "IGNORE THIS ERROR UNLESS IT IS SPAMMING");
            logger.log(Level.WARNING, "");
            logger.log(Level.SEVERE, x, () -> "An Error occurred while parsing Block Info for Slimefun " + SlimefunPlugin.getVersion());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String serializeBlockInfo(me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg) {
        StringWriter string2 = new StringWriter();
        try (JsonWriter writer = new JsonWriter((Writer)string2);){
            writer.setLenient(true);
            writer.beginObject();
            for (String key : cfg.getKeys()) {
                writer.name(key).value(cfg.getString(key));
            }
            writer.endObject();
            String string = string2.toString();
            return string;
        }
        catch (IOException x) {
            Slimefun.getLogger().log(Level.SEVERE, "An error occurred while serializing BlockInfo", x);
            return null;
        }
    }

    public static String getLocationInfo(Location l, String key) {
        return BlockStorage.getLocationInfo(l).getString(key);
    }

    public static void addBlockInfo(Location l, String key, String value) {
        BlockStorage.addBlockInfo(l, key, value, false);
    }

    public static void addBlockInfo(Block block, String key, String value) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value);
    }

    public static void addBlockInfo(Block block, String key, String value, boolean updateTicker) {
        BlockStorage.addBlockInfo(block.getLocation(), key, value, updateTicker);
    }

    public static void addBlockInfo(Location l, String key, String value, boolean updateTicker) {
        me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg = BlockStorage.hasBlockInfo(l) ? BlockStorage.getLocationInfo(l) : new BlockInfoConfig();
        cfg.setValue(key, (Object)value);
        BlockStorage.setBlockInfo(l, cfg, updateTicker);
    }

    public static boolean hasBlockInfo(Block block) {
        return BlockStorage.hasBlockInfo(block.getLocation());
    }

    public static boolean hasBlockInfo(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        return storage != null && storage.storage.containsKey(l) && BlockStorage.getLocationInfo(l, "id") != null;
    }

    public static void setBlockInfo(Block block, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg, boolean updateTicker) {
        BlockStorage.setBlockInfo(block.getLocation(), cfg, updateTicker);
    }

    public static void setBlockInfo(Location l, me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg, boolean updateTicker) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            Slimefun.getLogger().warning("Could not set Block info for non-registered World '" + l.getWorld().getName() + "'. Is some plugin trying to store data in a fake world?");
            return;
        }
        storage.storage.put(l, cfg);
        String id = cfg.getString("id");
        if (BlockMenuPreset.isInventory(id)) {
            if (BlockMenuPreset.isUniversalInventory(id)) {
                if (!SlimefunPlugin.getRegistry().getUniversalInventories().containsKey(id)) {
                    storage.loadUniversalInventory(BlockMenuPreset.getPreset(id));
                }
            } else if (!storage.hasInventory(l)) {
                File file = new File(PATH_INVENTORIES + BlockStorage.serializeLocation(l) + ".sfi");
                if (file.exists()) {
                    storage.inventories.put(l, new BlockMenu(BlockMenuPreset.getPreset(id), l, new Config(file)));
                } else {
                    storage.loadInventory(l, BlockMenuPreset.getPreset(id));
                }
            }
        }
        BlockStorage.refreshCache(storage, l, id, BlockStorage.serializeBlockInfo(cfg), updateTicker);
    }

    public static void setBlockInfo(Block b, String json, boolean updateTicker) {
        BlockStorage.setBlockInfo(b.getLocation(), json, updateTicker);
    }

    public static void setBlockInfo(Location l, String json, boolean updateTicker) {
        BlockInfoConfig blockInfo;
        BlockInfoConfig blockInfoConfig = blockInfo = json == null ? new BlockInfoConfig() : BlockStorage.parseBlockInfo(l, json);
        if (blockInfo == null) {
            return;
        }
        BlockStorage.setBlockInfo(l, (me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config)blockInfo, updateTicker);
    }

    public static void clearBlockInfo(Block block) {
        BlockStorage.clearBlockInfo(block.getLocation());
    }

    public static void clearBlockInfo(Location l) {
        BlockStorage.clearBlockInfo(l, true);
    }

    public static void clearBlockInfo(Block b, boolean destroy) {
        BlockStorage.clearBlockInfo(b.getLocation(), destroy);
    }

    public static void clearBlockInfo(Location l, boolean destroy) {
        SlimefunPlugin.getTickerTask().queueDelete(l, destroy);
    }

    public static void _integrated_removeBlockInfo(Location l, boolean destroy) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (BlockStorage.hasBlockInfo(l)) {
            BlockStorage.refreshCache(storage, l, BlockStorage.getLocationInfo(l).getString("id"), null, destroy);
            storage.storage.remove(l);
        }
        if (destroy) {
            UniversalBlockMenu universalInventory;
            if (storage.hasInventory(l)) {
                storage.clearInventory(l);
            }
            if ((universalInventory = BlockStorage.getUniversalInventory(l)) != null) {
                universalInventory.close();
                universalInventory.save();
            }
            String chunkString = BlockStorage.locationToChunkString(l);
            if (SlimefunPlugin.getRegistry().getActiveTickers().containsKey(chunkString)) {
                Set<Location> locations = SlimefunPlugin.getRegistry().getActiveTickers().get(chunkString);
                locations.remove(l);
                if (locations.isEmpty()) {
                    SlimefunPlugin.getRegistry().getActiveTickers().remove(chunkString);
                    SlimefunPlugin.getRegistry().getActiveChunks().remove(chunkString);
                } else {
                    SlimefunPlugin.getRegistry().getActiveTickers().put(chunkString, locations);
                }
            }
        }
    }

    public static void moveBlockInfo(Location from, Location to) {
        SlimefunPlugin.getTickerTask().queueMove(from, to);
    }

    public static void _integrated_moveLocationInfo(Location from, Location to) {
        if (!BlockStorage.hasBlockInfo(from)) {
            return;
        }
        BlockStorage storage = BlockStorage.getStorage(from.getWorld());
        BlockStorage.setBlockInfo(to, BlockStorage.getLocationInfo(from), true);
        if (storage.inventories.containsKey(from)) {
            BlockMenu menu = storage.inventories.get(from);
            storage.inventories.put(to, menu);
            storage.clearInventory(from);
            menu.move(to);
        }
        BlockStorage.refreshCache(storage, from, BlockStorage.getLocationInfo(from).getString("id"), null, true);
        storage.storage.remove(from);
        String chunkString = BlockStorage.locationToChunkString(from);
        if (SlimefunPlugin.getRegistry().getActiveTickers().containsKey(chunkString)) {
            Set<Location> locations = SlimefunPlugin.getRegistry().getActiveTickers().get(chunkString);
            locations.remove(from);
            if (locations.isEmpty()) {
                SlimefunPlugin.getRegistry().getActiveTickers().remove(chunkString);
                SlimefunPlugin.getRegistry().getActiveChunks().remove(chunkString);
            } else {
                SlimefunPlugin.getRegistry().getActiveTickers().put(chunkString, locations);
            }
        }
    }

    private static void refreshCache(BlockStorage storage, Location l, String key, String value, boolean updateTicker) {
        SlimefunItem item;
        if (key == null) {
            return;
        }
        me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config cfg = storage.blocksCache.computeIfAbsent(key, k -> new me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config(PATH_BLOCKS + l.getWorld().getName() + '/' + key + ".sfb"));
        cfg.setValue(BlockStorage.serializeLocation(l), (Object)value);
        if (updateTicker && (item = SlimefunItem.getByID(key)) != null && item.isTicking()) {
            String chunkString = BlockStorage.locationToChunkString(l);
            if (value != null) {
                Set<Location> locations = SlimefunPlugin.getRegistry().getActiveTickers().get(chunkString);
                if (locations == null) {
                    locations = new HashSet<Location>();
                }
                locations.add(l);
                SlimefunPlugin.getRegistry().getActiveTickers().put(chunkString, locations);
                SlimefunPlugin.getRegistry().getActiveChunks().add(chunkString);
            }
        }
    }

    public static SlimefunItem check(Block block) {
        return BlockStorage.check(block.getLocation());
    }

    public static SlimefunItem check(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return null;
        }
        return SlimefunItem.getByID(BlockStorage.getLocationInfo(l, "id"));
    }

    public static String checkID(Block b) {
        Optional<String> blockData;
        if (SlimefunPlugin.getBlockDataService().isTileEntity(b.getType()) && (blockData = SlimefunPlugin.getBlockDataService().getBlockData(b)).isPresent()) {
            return blockData.get();
        }
        return BlockStorage.checkID(b.getLocation());
    }

    public static boolean check(Block block, String slimefunItem) {
        String id = BlockStorage.checkID(block);
        return id != null && id.equals(slimefunItem);
    }

    public static String checkID(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return null;
        }
        return BlockStorage.getLocationInfo(l, "id");
    }

    public static boolean check(Location l, String slimefunItem) {
        if (slimefunItem == null || !BlockStorage.hasBlockInfo(l)) {
            return false;
        }
        try {
            String id = BlockStorage.getLocationInfo(l, "id");
            return id != null && id.equalsIgnoreCase(slimefunItem);
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Exception occurred while checking " + new BlockPosition(l) + " for: \"" + slimefunItem + "\"");
            return false;
        }
    }

    public static boolean isWorldRegistered(String name) {
        return SlimefunPlugin.getRegistry().getWorlds().containsKey(name);
    }

    public static Set<String> getTickingChunks() {
        return new HashSet<String>(SlimefunPlugin.getRegistry().getActiveChunks());
    }

    public static Set<Location> getTickingLocations(Chunk chunk) {
        return BlockStorage.getTickingLocations(chunk.toString());
    }

    public static Set<Location> getTickingLocations(String chunk) {
        return new HashSet<Location>((Collection)SlimefunPlugin.getRegistry().getActiveTickers().get(chunk));
    }

    public BlockMenu loadInventory(Location l, BlockMenuPreset preset) {
        if (preset == null) {
            return null;
        }
        BlockMenu menu = new BlockMenu(preset, l);
        this.inventories.put(l, menu);
        return menu;
    }

    public void reloadInventory(Location l) {
        BlockMenu menu = this.inventories.get(l);
        if (menu != null) {
            menu.reload();
        }
    }

    public void loadUniversalInventory(BlockMenuPreset preset) {
        SlimefunPlugin.getRegistry().getUniversalInventories().put(preset.getID(), new UniversalBlockMenu(preset));
    }

    public void clearInventory(Location l) {
        BlockMenu menu = BlockStorage.getInventory(l);
        if (menu != null) {
            for (HumanEntity human : new ArrayList(menu.toInventory().getViewers())) {
                Slimefun.runSync(() -> ((HumanEntity)human).closeInventory());
            }
            this.inventories.get(l).delete(l);
            this.inventories.remove(l);
        }
    }

    public boolean hasInventory(Location l) {
        return this.inventories.containsKey(l);
    }

    public static boolean hasUniversalInventory(String id) {
        return SlimefunPlugin.getRegistry().getUniversalInventories().containsKey(id);
    }

    public static UniversalBlockMenu getUniversalInventory(Block block) {
        return BlockStorage.getUniversalInventory(block.getLocation());
    }

    public static UniversalBlockMenu getUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id == null ? null : BlockStorage.getUniversalInventory(id);
    }

    public static UniversalBlockMenu getUniversalInventory(String id) {
        return SlimefunPlugin.getRegistry().getUniversalInventories().get(id);
    }

    public static BlockMenu getInventory(Block b) {
        return BlockStorage.getInventory(b.getLocation());
    }

    public static boolean hasInventory(Block b) {
        BlockStorage storage = BlockStorage.getStorage(b.getWorld());
        if (storage == null) {
            return false;
        }
        return storage.hasInventory(b.getLocation());
    }

    public static BlockMenu getInventory(Location l) {
        BlockStorage storage = BlockStorage.getStorage(l.getWorld());
        if (storage == null) {
            return null;
        }
        BlockMenu menu = storage.inventories.get(l);
        if (menu != null) {
            return menu;
        }
        return storage.loadInventory(l, BlockMenuPreset.getPreset(BlockStorage.checkID(l)));
    }

    public static me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config getChunkInfo(World world, int x, int z) {
        try {
            if (!BlockStorage.isWorldRegistered(world.getName())) {
                return emptyBlockData;
            }
            String key = BlockStorage.serializeChunk(world, x, z);
            BlockInfoConfig cfg = SlimefunPlugin.getRegistry().getChunks().get(key);
            if (cfg == null) {
                cfg = new BlockInfoConfig();
                SlimefunPlugin.getRegistry().getChunks().put(key, cfg);
            }
            return cfg;
        }
        catch (Exception e) {
            Slimefun.getLogger().log(Level.SEVERE, e, () -> "Failed to parse ChunkInfo for Slimefun " + SlimefunPlugin.getVersion());
            return emptyBlockData;
        }
    }

    public static void setChunkInfo(World world, int x, int z, String key, String value) {
        String serializedChunk = BlockStorage.serializeChunk(world, x, z);
        BlockInfoConfig cfg = SlimefunPlugin.getRegistry().getChunks().get(serializedChunk);
        if (cfg == null) {
            cfg = new BlockInfoConfig();
            SlimefunPlugin.getRegistry().getChunks().put(serializedChunk, cfg);
        }
        cfg.setValue(key, value);
        ++chunkChanges;
    }

    public static boolean hasChunkInfo(World world, int x, int z) {
        String serializedChunk = BlockStorage.serializeChunk(world, x, z);
        return SlimefunPlugin.getRegistry().getChunks().containsKey(serializedChunk);
    }

    public static String getChunkInfo(World world, int x, int z, String key) {
        return BlockStorage.getChunkInfo(world, x, z).getString(key);
    }

    public static String getBlockInfoAsJson(Block block) {
        return BlockStorage.getBlockInfoAsJson(block.getLocation());
    }

    public static String getBlockInfoAsJson(Location l) {
        return BlockStorage.serializeBlockInfo(BlockStorage.getLocationInfo(l));
    }

    public boolean hasUniversalInventory(Block block) {
        return this.hasUniversalInventory(block.getLocation());
    }

    public boolean hasUniversalInventory(Location l) {
        String id = BlockStorage.checkID(l);
        return id != null && BlockStorage.hasUniversalInventory(id);
    }
}

