/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceRating;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.SlimefunProfiler;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class PerformanceSummary {
    private static final int VISIBILITY_THRESHOLD = 280000;
    static final int MAX_TICK_DURATION = 100;
    private final SlimefunProfiler profiler;
    private final PerformanceRating rating;
    private final long totalElapsedTime;
    private final int totalTickedBlocks;
    private final float percentage;
    private final Map<String, Long> chunks;
    private final Map<String, Long> plugins;
    private final Map<String, Long> items;

    PerformanceSummary(SlimefunProfiler profiler, long totalElapsedTime, int totalTickedBlocks) {
        this.profiler = profiler;
        this.rating = profiler.getPerformance();
        this.percentage = profiler.getPercentageOfTick();
        this.totalElapsedTime = totalElapsedTime;
        this.totalTickedBlocks = totalTickedBlocks;
        this.chunks = profiler.getByChunk();
        this.plugins = profiler.getByPlugin();
        this.items = profiler.getByItem();
    }

    public void send(CommandSender sender) {
        sender.sendMessage("");
        sender.sendMessage(ChatColor.GREEN + "===== Slimefun Lag Profiler =====");
        sender.sendMessage(ChatColor.GOLD + "Total: " + ChatColor.YELLOW + NumberUtils.getAsMillis(this.totalElapsedTime));
        sender.sendMessage(ChatColor.GOLD + "Performance: " + this.getPerformanceRating());
        sender.sendMessage("");
        this.summarizeTimings(this.totalTickedBlocks + " Blocks", sender, this.items, entry -> {
            int count = this.profiler.getBlocksOfId((String)entry.getKey());
            String time = NumberUtils.getAsMillis((Long)entry.getValue());
            if (count > 1) {
                String average = NumberUtils.getAsMillis((Long)entry.getValue() / (long)count);
                return (String)entry.getKey() + " - " + count + "x (" + time + " | avg: " + average + ')';
            }
            return (String)entry.getKey() + " - " + count + "x (" + time + ')';
        });
        this.summarizeTimings(this.chunks.size() + " Chunks", sender, this.chunks, entry -> {
            int count = this.profiler.getBlocksInChunk((String)entry.getKey());
            String time = NumberUtils.getAsMillis((Long)entry.getValue());
            return (String)entry.getKey() + " - " + count + "x Blocks (" + time + ")";
        });
        this.summarizeTimings(this.plugins.size() + " Plugins", sender, this.plugins, entry -> {
            int count = this.profiler.getBlocksFromPlugin((String)entry.getKey());
            String time = NumberUtils.getAsMillis((Long)entry.getValue());
            return (String)entry.getKey() + " - " + count + "x Blocks (" + time + ")";
        });
    }

    private void summarizeTimings(String prefix, CommandSender sender, Map<String, Long> map, Function<Map.Entry<String, Long>, String> formatter) {
        Stream stream = map.entrySet().stream();
        List results = stream.sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
        if (sender instanceof Player) {
            TextComponent component = new TextComponent(prefix);
            component.setColor(ChatColor.YELLOW);
            TextComponent hoverComponent = new TextComponent("  (Hover for details)");
            hoverComponent.setColor(ChatColor.GRAY);
            StringBuilder builder = new StringBuilder();
            int hidden = 0;
            for (Map.Entry entry : results) {
                if ((Long)entry.getValue() > 280000L) {
                    builder.append("\n").append(ChatColor.YELLOW).append(formatter.apply(entry));
                    continue;
                }
                ++hidden;
            }
            builder.append("\n\n&c+ &6").append(hidden).append(" more");
            hoverComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)ChatColors.color(builder.toString()))));
            component.addExtra((BaseComponent)hoverComponent);
            sender.spigot().sendMessage((BaseComponent)component);
        } else {
            int hidden = 0;
            StringBuilder builder = new StringBuilder();
            builder.append(ChatColor.GOLD);
            builder.append(prefix);
            builder.append(ChatColor.YELLOW);
            for (Map.Entry entry : results) {
                if ((Long)entry.getValue() > 280000L) {
                    builder.append("\n  ");
                    builder.append(ChatColor.stripColor((String)formatter.apply(entry)));
                    continue;
                }
                ++hidden;
            }
            builder.append("\n+ ");
            builder.append(hidden);
            builder.append(" more...");
            sender.sendMessage(builder.toString());
        }
    }

    private String getPerformanceRating() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append(NumberUtils.getColorFromPercentage(100.0f - Math.min(this.percentage, 100.0f)));
        int rest = 20;
        for (i = (int)Math.min(this.percentage, 100.0f); i >= 5; i -= 5) {
            builder.append(':');
            --rest;
        }
        builder.append(ChatColor.DARK_GRAY);
        for (i = 0; i < rest; ++i) {
            builder.append(':');
        }
        builder.append(" - ");
        builder.append(this.rating.getColor() + ChatUtils.humanize(this.rating.name()));
        builder.append(ChatColor.GRAY);
        builder.append(" (");
        builder.append(NumberUtils.roundDecimalNumber(this.percentage));
        builder.append("%)");
        return builder.toString();
    }
}

