/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.handlers;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Arrays;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.LoopIterator;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollection;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;

public class RainbowTickHandler
extends BlockTicker {
    private final LoopIterator<Material> iterator;
    private final boolean waterlogged;
    private Material material;

    public RainbowTickHandler(Material ... materials) {
        if (materials.length == 0) {
            throw new IllegalArgumentException("A RainbowTicker must have at least one Material associated with it!");
        }
        this.waterlogged = this.containsWaterlogged(materials);
        this.iterator = new LoopIterator<Material>(Arrays.asList(materials));
        this.material = this.iterator.next();
    }

    private boolean containsWaterlogged(Material[] materials) {
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return false;
        }
        for (Material type : materials) {
            if (!(type.createBlockData() instanceof Waterlogged)) continue;
            return true;
        }
        return false;
    }

    public RainbowTickHandler(MaterialCollection collection) {
        this(collection.getAsArray());
    }

    @Override
    public void tick(Block b, SlimefunItem item, Config data) {
        if (b.getType() == Material.AIR) {
            return;
        }
        if (this.waterlogged) {
            BlockData blockData = b.getBlockData();
            b.setType(this.material, true);
            if (blockData instanceof Waterlogged && ((Waterlogged)blockData).isWaterlogged()) {
                Waterlogged block = (Waterlogged)b.getBlockData();
                block.setWaterlogged(true);
                b.setBlockData((BlockData)block);
            }
        } else {
            b.setType(this.material, false);
        }
    }

    @Override
    public void uniqueTick() {
        this.material = this.iterator.next();
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }
}

