/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

final class RechargeableHelper {
    private static final NamespacedKey CHARGE_KEY = new NamespacedKey((Plugin)SlimefunPlugin.instance, "item_charge");
    private static final String LORE_PREFIX = ChatColors.color("&8\u21e8 &e\u26a1 &7");
    private static final Pattern REGEX = Pattern.compile(ChatColors.color("(&c&o)?" + LORE_PREFIX) + "[0-9\\.]+ \\/ [0-9\\.]+ J");

    private RechargeableHelper() {
    }

    static void setCharge(ItemMeta meta, float charge, float capacity) {
        BigDecimal decimal = BigDecimal.valueOf(charge).setScale(2, RoundingMode.HALF_UP);
        float value = decimal.floatValue();
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            meta.getPersistentDataContainer().set(CHARGE_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(value));
        }
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!REGEX.matcher(line).matches()) continue;
            lore.set(i, LORE_PREFIX + value + " / " + capacity + " J");
            meta.setLore(lore);
            return;
        }
        lore.add(LORE_PREFIX + value + " / " + capacity + " J");
        meta.setLore(lore);
    }

    static float getCharge(ItemMeta meta) {
        Float value;
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14) && (value = (Float)meta.getPersistentDataContainer().get(CHARGE_KEY, PersistentDataType.FLOAT)) != null) {
            return value.floatValue();
        }
        if (meta.hasLore()) {
            for (String line : meta.getLore()) {
                if (!REGEX.matcher(line).matches()) continue;
                return Float.parseFloat(PatternUtils.SLASH_SEPARATOR.split(line)[0].replace(LORE_PREFIX, ""));
            }
        }
        return 0.0f;
    }
}

