/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.energy;

import io.github.thebusybiscuit.slimefun4.api.ErrorReport;
import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.reactors.Reactor;
import io.github.thebusybiscuit.slimefun4.utils.holograms.SimpleHologram;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class EnergyNet
extends Network {
    private static final int RANGE = 6;
    private final Set<Location> generators = new HashSet<Location>();
    private final Set<Location> storage = new HashSet<Location>();
    private final Set<Location> consumers = new HashSet<Location>();

    public static EnergyNetComponentType getComponent(Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return EnergyNetComponentType.NONE;
        }
        if (SlimefunPlugin.getRegistry().getEnergyGenerators().contains(id)) {
            return EnergyNetComponentType.GENERATOR;
        }
        if (SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(id)) {
            return EnergyNetComponentType.CAPACITOR;
        }
        if (SlimefunPlugin.getRegistry().getEnergyConsumers().contains(id)) {
            return EnergyNetComponentType.CONSUMER;
        }
        return EnergyNetComponentType.NONE;
    }

    public static EnergyNet getNetworkFromLocationOrCreate(Location l) {
        Optional<EnergyNet> cargoNetwork = SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, EnergyNet.class);
        if (cargoNetwork.isPresent()) {
            return cargoNetwork.get();
        }
        EnergyNet network = new EnergyNet(l);
        SlimefunPlugin.getNetworkManager().registerNetwork(network);
        return network;
    }

    protected EnergyNet(Location l) {
        super(SlimefunPlugin.getNetworkManager(), l);
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public NetworkComponent classifyLocation(Location l) {
        if (this.regulator.equals((Object)l)) {
            return NetworkComponent.REGULATOR;
        }
        switch (EnergyNet.getComponent(l)) {
            case CAPACITOR: {
                return NetworkComponent.CONNECTOR;
            }
            case CONSUMER: 
            case GENERATOR: {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        if (from == NetworkComponent.TERMINUS) {
            this.generators.remove(l);
            this.consumers.remove(l);
        }
        switch (EnergyNet.getComponent(l)) {
            case CAPACITOR: {
                this.storage.add(l);
                break;
            }
            case CONSUMER: {
                this.consumers.add(l);
                break;
            }
            case GENERATOR: {
                this.generators.add(l);
                break;
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            SimpleHologram.update(b, "&4Multiple Energy Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            SimpleHologram.update(b, "&4No Energy Network found");
        } else {
            double supply = DoubleHandler.fixDouble(this.tickAllGenerators() + this.tickAllCapacitors());
            double demand = 0.0;
            int availableEnergy = (int)supply;
            for (Location machine : this.consumers) {
                int capacity = ChargableBlock.getMaxCharge(machine);
                int charge = ChargableBlock.getCharge(machine);
                if (charge >= capacity) continue;
                int availableSpace = capacity - charge;
                demand += (double)availableSpace;
                if (availableEnergy <= 0) continue;
                if (availableEnergy > availableSpace) {
                    ChargableBlock.setUnsafeCharge(machine, capacity, false);
                    availableEnergy -= availableSpace;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(machine, charge + availableEnergy, false);
                availableEnergy = 0;
            }
            this.storeExcessEnergy(availableEnergy);
            this.updateHologram(b, supply, demand);
        }
    }

    private void storeExcessEnergy(int available) {
        int capacity;
        for (Location capacitor : this.storage) {
            if (available > 0) {
                capacity = ChargableBlock.getMaxCharge(capacitor);
                if (available > capacity) {
                    ChargableBlock.setUnsafeCharge(capacitor, capacity, true);
                    available -= capacity;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(capacitor, available, true);
                available = 0;
                continue;
            }
            ChargableBlock.setUnsafeCharge(capacitor, 0, true);
        }
        for (Location generator : this.generators) {
            capacity = ChargableBlock.getMaxCharge(generator);
            if (capacity <= 0) continue;
            if (available > 0) {
                if (available > capacity) {
                    ChargableBlock.setUnsafeCharge(generator, capacity, false);
                    available -= capacity;
                    continue;
                }
                ChargableBlock.setUnsafeCharge(generator, available, false);
                available = 0;
                continue;
            }
            ChargableBlock.setUnsafeCharge(generator, 0, false);
        }
    }

    private double tickAllGenerators() {
        double supply = 0.0;
        HashSet<Location> exploded = new HashSet<Location>();
        for (Location source : this.generators) {
            long timestamp = SlimefunPlugin.getProfiler().newEntry();
            Config config = BlockStorage.getLocationInfo(source);
            SlimefunItem item = SlimefunItem.getByID(config.getString("id"));
            if (item != null) {
                try {
                    GeneratorTicker generator = item.getEnergyTicker();
                    if (generator != null) {
                        double energy = generator.generateEnergy(source, item, config);
                        if (generator.explode(source)) {
                            exploded.add(source);
                            BlockStorage.clearBlockInfo(source);
                            Reactor.processing.remove(source);
                            Reactor.progress.remove(source);
                            Slimefun.runSync(() -> {
                                source.getBlock().setType(Material.LAVA);
                                source.getWorld().createExplosion(source, 0.0f, false);
                            });
                        } else {
                            supply += energy;
                        }
                    } else {
                        item.warn("This Item was marked as a 'GENERATOR' but has no 'GeneratorTicker' attached to it! This must be fixed.");
                    }
                }
                catch (Exception | LinkageError t) {
                    exploded.add(source);
                    new ErrorReport(t, source, item);
                }
                SlimefunPlugin.getProfiler().closeEntry(source, item, timestamp);
                continue;
            }
            exploded.add(source);
        }
        this.generators.removeAll(exploded);
        return supply;
    }

    private double tickAllCapacitors() {
        double supply = 0.0;
        for (Location capacitor : this.storage) {
            supply += (double)ChargableBlock.getCharge(capacitor);
        }
        return supply;
    }

    private void updateHologram(Block b, double supply, double demand) {
        if (demand > supply) {
            String netLoss = DoubleHandler.getFancyDouble(Math.abs(supply - demand));
            SimpleHologram.update(b, "&4&l- &c" + netLoss + " &7J &e\u26a1");
        } else {
            String netGain = DoubleHandler.getFancyDouble(supply - demand);
            SimpleHologram.update(b, "&2&l+ &a" + netGain + " &7J &e\u26a1");
        }
    }
}

