/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.energy;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public final class ChargableBlock {
    private ChargableBlock() {
    }

    public static boolean isChargable(Block b) {
        return ChargableBlock.isChargable(b.getLocation());
    }

    public static boolean isChargable(Location l) {
        if (!BlockStorage.hasBlockInfo(l)) {
            return false;
        }
        String id = BlockStorage.checkID(l);
        return SlimefunPlugin.getRegistry().getEnergyCapacities().containsKey(id);
    }

    public static int getCharge(Block b) {
        return ChargableBlock.getCharge(b.getLocation());
    }

    public static int getCharge(Location l) {
        String charge = BlockStorage.getLocationInfo(l, "energy-charge");
        if (charge != null) {
            return Integer.parseInt(charge);
        }
        BlockStorage.addBlockInfo(l, "energy-charge", "0", false);
        return 0;
    }

    public static void setCharge(Block b, int charge) {
        ChargableBlock.setCharge(b.getLocation(), charge);
    }

    public static void setCharge(Location l, int charge) {
        if (charge < 0) {
            charge = 0;
        } else {
            int capacity = ChargableBlock.getMaxCharge(l);
            if (charge > capacity) {
                charge = capacity;
            }
        }
        if (charge != ChargableBlock.getCharge(l)) {
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(charge), false);
        }
    }

    public static void setUnsafeCharge(Location l, int charge, boolean updateTexture) {
        if (charge != ChargableBlock.getCharge(l)) {
            BlockStorage.addBlockInfo(l, "energy-charge", String.valueOf(charge), false);
            if (updateTexture) {
                ChargableBlock.updateCapacitor(l);
            }
        }
    }

    public static int addCharge(Block b, int charge) {
        return ChargableBlock.addCharge(b.getLocation(), charge);
    }

    public static int addCharge(Location l, int charge) {
        int capacity = ChargableBlock.getMaxCharge(l);
        int energy = ChargableBlock.getCharge(l);
        int space = capacity - energy;
        int rest = charge;
        if (space > 0 && charge > 0) {
            if (space > charge) {
                ChargableBlock.setCharge(l, energy + charge);
                rest = 0;
            } else {
                rest = charge - space;
                ChargableBlock.setCharge(l, capacity);
            }
            if (SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(BlockStorage.checkID(l))) {
                ChargableBlock.updateCapacitor(l);
            }
        } else if (charge < 0 && energy >= -charge) {
            ChargableBlock.setCharge(l, energy + charge);
            if (SlimefunPlugin.getRegistry().getEnergyCapacitors().contains(BlockStorage.checkID(l))) {
                ChargableBlock.updateCapacitor(l);
            }
        }
        return rest;
    }

    private static void updateCapacitor(Location l) {
        Slimefun.runSync(() -> {
            Block b = l.getBlock();
            int charge = ChargableBlock.getCharge(b);
            int capacity = ChargableBlock.getMaxCharge(b);
            if (b.getType() == Material.PLAYER_HEAD || b.getType() == Material.PLAYER_WALL_HEAD) {
                if (charge < (int)((double)capacity * 0.25)) {
                    SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_25.getTexture());
                } else if (charge < (int)((double)capacity * 0.5)) {
                    SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_50.getTexture());
                } else if (charge < (int)((double)capacity * 0.75)) {
                    SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_75.getTexture());
                } else {
                    SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_100.getTexture());
                }
            }
        });
    }

    public static int getMaxCharge(Block b) {
        return ChargableBlock.getMaxCharge(b.getLocation());
    }

    public static int getMaxCharge(Location l) {
        Config cfg = BlockStorage.getLocationInfo(l);
        String id = cfg.getString("id");
        if (id == null) {
            BlockStorage.clearBlockInfo(l);
            return 0;
        }
        return SlimefunPlugin.getRegistry().getEnergyCapacities().getOrDefault(id, 0);
    }
}

