/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.weapons;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.implementation.items.weapons.SlimefunBow;
import java.util.Collection;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.handlers.BowShootHandler;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ExplosiveBow
extends SlimefunBow {
    private final ItemSetting<Integer> range = new ItemSetting<Integer>("explosion-range", Integer.valueOf(3)){

        @Override
        public boolean validateInput(Integer input) {
            return input != null && input > 0;
        }
    };

    public ExplosiveBow(Category category, SlimefunItemStack item, ItemStack[] recipe) {
        super(category, item, recipe);
        this.addItemSetting(this.range);
    }

    @Override
    public BowShootHandler onShoot() {
        return (e, target) -> {
            target.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, target.getLocation(), 1);
            target.getWorld().playSound(target.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
            Collection entites = target.getWorld().getNearbyEntities(target.getLocation(), (double)this.range.getValue().intValue(), (double)this.range.getValue().intValue(), (double)this.range.getValue().intValue(), entity -> entity instanceof LivingEntity && entity.isValid());
            for (Entity entity2 : entites) {
                LivingEntity entityL = (LivingEntity)entity2;
                Vector distanceVector = entityL.getLocation().toVector().subtract(target.getLocation().toVector());
                distanceVector.setY(distanceVector.getY() + 0.6);
                Vector entityVelocity = entityL.getVelocity();
                double distanceSquared = distanceVector.lengthSquared();
                double damage = this.calculateDamage(distanceSquared, e.getDamage());
                Vector knockback = entityVelocity.add(distanceVector.normalize().multiply((int)(e.getDamage() / damage)));
                entityL.setVelocity(knockback);
                if (entityL.getUniqueId().equals(target.getUniqueId())) continue;
                EntityDamageByEntityEvent damageEvent = new EntityDamageByEntityEvent(e.getDamager(), (Entity)entityL, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, damage);
                Bukkit.getPluginManager().callEvent((Event)damageEvent);
                if (damageEvent.isCancelled()) continue;
                entityL.damage(damageEvent.getDamage());
            }
        };
    }

    private double calculateDamage(double distanceSquared, double originalDamage) {
        if (distanceSquared <= 0.05) {
            return originalDamage;
        }
        double damage = originalDamage * (1.0 - distanceSquared / (double)(this.range.getValue() * this.range.getValue()));
        return Math.min(Math.max(1.0, damage), originalDamage);
    }
}

