/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.Vein;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialConverter;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public abstract class WoodcutterAndroid
extends ProgrammableAndroid {
    public WoodcutterAndroid(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public AndroidType getAndroidType() {
        return AndroidType.WOODCUTTER;
    }

    @Override
    protected boolean chopTree(Block b, BlockMenu menu, BlockFace face) {
        List<Block> list;
        if (MaterialCollections.getAllLogs().contains(b.getRelative(face).getType()) && !(list = Vein.find(b.getRelative(face), 180, block -> MaterialCollections.getAllLogs().contains(block.getType()))).isEmpty()) {
            Block log = list.get(list.size() - 1);
            log.getWorld().playEffect(log.getLocation(), Effect.STEP_SOUND, (Object)log.getType());
            if (SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner"))), log.getLocation(), ProtectableAction.BREAK_BLOCK)) {
                this.breakLog(log, b, menu, face);
            }
            return false;
        }
        return true;
    }

    private void breakLog(Block log, Block android, BlockMenu menu, BlockFace face) {
        ItemStack drop = new ItemStack(log.getType());
        if (menu.fits(drop, this.getOutputSlots())) {
            menu.pushItem(drop, this.getOutputSlots());
            log.getWorld().playEffect(log.getLocation(), Effect.STEP_SOUND, (Object)log.getType());
            if (log.getY() == android.getRelative(face).getY()) {
                Optional<Material> sapling = MaterialConverter.getSaplingFromLog(log.getType());
                if (sapling.isPresent()) {
                    log.setType(sapling.get());
                }
            } else {
                log.setType(Material.AIR);
            }
        }
    }
}

