/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class Script {
    private final Config config;
    private final String name;
    private final String author;
    private final String code;

    private Script(Config config) {
        Validate.notNull((Object)config);
        this.config = config;
        this.name = config.getString("name");
        this.code = config.getString("code");
        String uuid = config.getString("author");
        Validate.notNull((Object)this.name);
        Validate.notNull((Object)this.code);
        Validate.notNull((Object)uuid);
        Validate.notNull(config.getStringList("rating.positive"));
        Validate.notNull(config.getStringList("rating.negative"));
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
        this.author = player.getName() != null ? player.getName() : config.getString("author_name");
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSourceCode() {
        return this.code;
    }

    public boolean isAuthor(OfflinePlayer p) {
        return p.getUniqueId().equals(this.config.getUUID("author"));
    }

    public boolean canRate(Player p) {
        if (this.isAuthor((OfflinePlayer)p)) {
            return false;
        }
        List<String> upvoters = this.config.getStringList("rating.positive");
        List<String> downvoters = this.config.getStringList("rating.negative");
        return !upvoters.contains(p.getUniqueId().toString()) && !downvoters.contains(p.getUniqueId().toString());
    }

    public int getUpvotes() {
        return this.config.getStringList("rating.positive").size();
    }

    public int getDownvotes() {
        return this.config.getStringList("rating.negative").size();
    }

    public int getDownloads() {
        return this.config.getInt("downloads");
    }

    public float getRating() {
        int positive = this.getUpvotes() + 1;
        int negative = this.getDownvotes();
        return (float)Math.round((float)positive / (float)(positive + negative) * 100.0f) / 100.0f;
    }

    public void download() {
        this.config.reload();
        this.config.setValue("downloads", this.getDownloads() + 1);
        this.config.save();
    }

    public void rate(Player p, boolean positive) {
        this.config.reload();
        String path = "rating." + (positive ? "positive" : "negative");
        List<String> list = this.config.getStringList(path);
        list.add(p.getUniqueId().toString());
        this.config.setValue(path, list);
        this.config.save();
    }

    public static List<Script> getUploadedScripts(AndroidType androidType) {
        LinkedList<Script> scripts = new LinkedList<Script>();
        Script.loadScripts(scripts, androidType);
        if (androidType != AndroidType.NONE) {
            Script.loadScripts(scripts, AndroidType.NONE);
        }
        Collections.sort(scripts, Comparator.comparingInt(script -> -script.getUpvotes() + 1 - script.getDownvotes()));
        return scripts;
    }

    private static void loadScripts(List<Script> scripts, AndroidType type) {
        File directory = new File("plugins/Slimefun/scripts/" + type.name());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        for (File file : directory.listFiles()) {
            if (!file.getName().endsWith(".sfs")) continue;
            try {
                Config config = new Config(file);
                if (!config.contains("code") || !config.contains("author")) continue;
                scripts.add(new Script(config));
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Exception occurred while trying to load Android Script '" + file.getName() + "'");
            }
        }
    }

    public static void upload(Player p, AndroidType androidType, int id, String name, String code) {
        Config config = new Config("plugins/Slimefun/scripts/" + androidType.name() + '/' + p.getName() + ' ' + id + ".sfs");
        config.setValue("author", p.getUniqueId().toString());
        config.setValue("author_name", p.getName());
        config.setValue("name", ChatUtils.removeColorCodes(name));
        config.setValue("code", code);
        config.setValue("downloads", 0);
        config.setValue("android", androidType.name());
        config.setValue("rating.positive", new ArrayList());
        config.setValue("rating.negative", new ArrayList());
        config.save();
    }
}

